/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.jta.hibernate;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.transaction.TransactionManagerLookup;

public class AS7TransactionManagerLookup
implements TransactionManagerLookup {
    private static final Logger LOGGER = Logger.getLogger(AS7TransactionManagerLookup.class);

    public Object getTransactionIdentifier(Transaction transaction) {
        return transaction;
    }

    public TransactionManager getTransactionManager(Properties properties) throws HibernateException {
        return (TransactionManager)AS7TransactionManagerLookup.jndiLookup(properties, "java:jboss/TransactionManager");
    }

    public String getUserTransactionName() {
        return "java:jboss/UserTransaction";
    }

    public static TransactionManager getTransactionManager() {
        return (TransactionManager)AS7TransactionManagerLookup.jndiLookup(null, "java:jboss/TransactionManager");
    }

    public static UserTransaction getUserTransaction() {
        return (UserTransaction)AS7TransactionManagerLookup.jndiLookup(null, "java:jboss/UserTransaction");
    }

    private static Object jndiLookup(Properties properties, String name) throws HibernateException {
        InitialContext ctx = null;
        try {
            ctx = properties != null ? new InitialContext(properties) : new InitialContext();
            Object object = ctx.lookup(name);
            return object;
        }
        catch (NamingException ne) {
            LOGGER.error((Object)ne.getMessage());
            throw new HibernateException((Throwable)ne);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable t) {
                    LOGGER.error((Object)t.getMessage());
                }
            }
        }
    }
}

