/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.task.service.jbpm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jbpm.task.Content;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.utils.MarshalledContentWrapper;
import org.switchyard.common.type.Classes;
import org.switchyard.component.bpm.task.service.BaseTaskContent;
import org.switchyard.exception.SwitchYardException;

public class JBPMTaskContent
extends BaseTaskContent {
    public JBPMTaskContent(Content content) {
        this(content.getContent());
    }

    public JBPMTaskContent(ContentData contentData) {
        this(contentData.getContent());
    }

    public JBPMTaskContent(byte[] bytes) {
        this.setObject(this.readObject(this.readBytes(bytes)));
    }

    private Object readObject(Object object) {
        if (object != null) {
            if (object instanceof Collection) {
                object = this.readCollection((Collection)object);
            } else if (object instanceof Map) {
                object = this.readMap((Map)object);
            } else if (object.getClass().isArray()) {
                object = this.readArray((Object[])object);
            } else if (object instanceof MarshalledContentWrapper) {
                object = this.readBytes(((MarshalledContentWrapper)object).getContent());
            }
        }
        return object;
    }

    private Collection<?> readCollection(Collection<?> collection) {
        ArrayList<Object> c = new ArrayList<Object>();
        for (Object o : collection) {
            c.add(this.readObject(o));
        }
        return collection;
    }

    private Map<Object, Object> readMap(Map<?, ?> map) {
        LinkedHashMap<Object, Object> m = new LinkedHashMap<Object, Object>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            m.put(entry.getKey(), this.readObject(entry.getValue()));
        }
        return m;
    }

    private Object[] readArray(Object[] array) {
        Object[] a = new Object[array.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.readObject(array[i]);
        }
        return a;
    }

    private Object readBytes(byte[] bytes) {
        Object object = null;
        if (bytes != null && bytes.length > 0) {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(bais){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                        Class<?> clazz = Classes.forName((String)desc.getName(), this.getClass());
                        return clazz != null ? clazz : super.resolveClass(desc);
                    }
                };
                object = ois.readObject();
            }
            catch (IOException ioe) {
                throw new SwitchYardException((Throwable)ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new SwitchYardException((Throwable)cnfe);
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException ioe) {
                        throw new SwitchYardException((Throwable)ioe);
                    }
                }
            }
        }
        return object;
    }
}

