/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.exchange.drools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.drools.KnowledgeBase;
import org.drools.agent.KnowledgeAgent;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.DefaultAgendaEventListener;
import org.drools.event.rule.RuleFlowGroupActivatedEvent;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.ProcessRuntime;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.jbpm.persistence.processinstance.JPAProcessInstanceManagerFactory;
import org.jbpm.persistence.processinstance.JPASignalManagerFactory;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.io.resource.ResourceType;
import org.switchyard.common.io.resource.SimpleResource;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.Classes;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.component.bpm.ProcessActionType;
import org.switchyard.component.bpm.ProcessConstants;
import org.switchyard.component.bpm.config.model.BPMComponentImplementationModel;
import org.switchyard.component.bpm.config.model.ParametersModel;
import org.switchyard.component.bpm.config.model.ProcessActionModel;
import org.switchyard.component.bpm.config.model.ResultsModel;
import org.switchyard.component.bpm.config.model.TaskHandlerModel;
import org.switchyard.component.bpm.exchange.BaseBPMExchangeHandler;
import org.switchyard.component.bpm.jta.hibernate.AS7TransactionManagerLookup;
import org.switchyard.component.bpm.task.work.TaskHandler;
import org.switchyard.component.bpm.task.work.drools.DroolsTaskManager;
import org.switchyard.component.common.rules.config.model.AuditModel;
import org.switchyard.component.common.rules.config.model.ComponentImplementationModel;
import org.switchyard.component.common.rules.config.model.MappingModel;
import org.switchyard.component.common.rules.expression.ContextMap;
import org.switchyard.component.common.rules.expression.Expression;
import org.switchyard.component.common.rules.expression.ExpressionFactory;
import org.switchyard.component.common.rules.util.drools.Agents;
import org.switchyard.component.common.rules.util.drools.Audits;
import org.switchyard.component.common.rules.util.drools.Bases;
import org.switchyard.component.common.rules.util.drools.ComponentImplementationConfig;
import org.switchyard.component.common.rules.util.drools.Configs;
import org.switchyard.component.common.rules.util.drools.Environments;
import org.switchyard.component.common.rules.util.drools.Events;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.metadata.ServiceOperation;

public class DroolsBPMExchangeHandler
extends BaseBPMExchangeHandler {
    private static final Logger LOGGER = Logger.getLogger(DroolsBPMExchangeHandler.class);
    private static final String IGNORE_VARIABLE_PREFIX = "ignore-variable-";
    private static final AtomicInteger IGNORE_VARIABLE_COUNT = new AtomicInteger();
    private final Lock _stateLock = new ReentrantLock();
    private final Lock _processLock = new ReentrantLock();
    private final ServiceDomain _serviceDomain;
    private ComponentImplementationConfig _componentImplementationConfig;
    private String _processId;
    private boolean _persistent;
    private Integer _sessionId;
    private EntityManagerFactory _entityManagerFactory;
    private String _messageContentInName;
    private String _messageContentOutName;
    private KnowledgeAgent _kagent;
    private AuditModel _audit;
    private String _targetNamespace;
    private List<TaskHandlerModel> _taskHandlerModels = new ArrayList<TaskHandlerModel>();
    private List<TaskHandler> _taskHandlers = new ArrayList<TaskHandler>();
    private Map<String, ProcessActionModel> _actionModels = new HashMap<String, ProcessActionModel>();
    private Map<String, Scope> _parameterContextScopes = new HashMap<String, Scope>();
    private Map<String, Expression> _parameterExpressions = new HashMap<String, Expression>();
    private Map<String, Scope> _resultContextScopes = new HashMap<String, Scope>();
    private Map<String, Expression> _resultExpressions = new HashMap<String, Expression>();
    private KnowledgeBase _kbase;
    private KnowledgeSessionConfiguration _ksessionConfig;
    private Environment _environment;
    private StatefulKnowledgeSession _ksession;
    private KnowledgeRuntimeLogger _klogger;

    public DroolsBPMExchangeHandler(ServiceDomain serviceDomain) {
        this._serviceDomain = serviceDomain;
    }

    @Override
    public void init(QName qname, BPMComponentImplementationModel model) {
        ResultsModel results;
        ComponentModel cm;
        this._processId = model.getProcessId();
        this._persistent = model.isPersistent();
        this._sessionId = model.getSessionId();
        this._messageContentInName = model.getMessageContentInName();
        if (this._messageContentInName == null) {
            this._messageContentInName = "messageContentIn";
        }
        this._messageContentOutName = model.getMessageContentOutName();
        if (this._messageContentOutName == null) {
            this._messageContentOutName = "messageContentOut";
        }
        this._targetNamespace = (cm = model.getComponent()) != null ? cm.getTargetNamespace() : null;
        this._taskHandlerModels.addAll(model.getTaskHandlers());
        ClassLoader loader = Classes.getClassLoader(this.getClass());
        ResourceType.install((ClassLoader)loader);
        this._componentImplementationConfig = new ComponentImplementationConfig((ComponentImplementationModel)model, loader);
        HashMap<String, Object> env = new HashMap<String, Object>();
        Properties props = new Properties();
        if (this._persistent) {
            this._entityManagerFactory = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
            env.put("drools.persistence.jpa.EntityManagerFactory", this._entityManagerFactory);
            env.put("drools.transaction.TransactionManager", AS7TransactionManagerLookup.getTransactionManager());
            env.put("drools.transaction.Transaction", AS7TransactionManagerLookup.getUserTransaction());
            props.setProperty("drools.processInstanceManagerFactory", JPAProcessInstanceManagerFactory.class.getName());
            props.setProperty("drools.processSignalManagerFactory", JPASignalManagerFactory.class.getName());
        }
        this._componentImplementationConfig.setEnvironmentOverrides(env);
        this._componentImplementationConfig.setPropertiesOverrides(props);
        Resource procDef = model.getProcessDefinition();
        if (procDef != null && procDef.getType() == null) {
            procDef = new SimpleResource(procDef.getLocation(), "BPMN2");
        }
        if (model.isAgent()) {
            this._kagent = Agents.newAgent((ComponentImplementationConfig)this._componentImplementationConfig, (Resource[])new Resource[]{procDef});
            this._kbase = this._kagent.getKnowledgeBase();
        } else {
            this._kbase = Bases.newBase((ComponentImplementationConfig)this._componentImplementationConfig, (Resource[])new Resource[]{procDef});
        }
        this._ksessionConfig = Configs.getSessionConfiguration((ComponentImplementationConfig)this._componentImplementationConfig);
        this._environment = Environments.getEnvironment((ComponentImplementationConfig)this._componentImplementationConfig);
        this._audit = model.getAudit();
        for (ProcessActionModel pam : model.getProcessActions()) {
            this._actionModels.put(pam.getName(), pam);
        }
        ExpressionFactory factory = ExpressionFactory.instance();
        ParametersModel parameters = model.getParameters();
        if (parameters != null) {
            for (MappingModel mapping : parameters.getMappings()) {
                this._parameterContextScopes.put(mapping.getVariable(), mapping.getContextScope());
                this._parameterExpressions.put(mapping.getVariable(), factory.create(mapping));
            }
        }
        if ((results = model.getResults()) != null) {
            for (MappingModel mapping : results.getMappings()) {
                String var = Strings.trimToNull((String)mapping.getVariable());
                if (var == null) {
                    var = IGNORE_VARIABLE_PREFIX + IGNORE_VARIABLE_COUNT.incrementAndGet();
                }
                this._resultContextScopes.put(var, mapping.getContextScope());
                this._resultExpressions.put(var, factory.create(mapping));
            }
        }
    }

    public void start() {
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        if (!ExchangePhase.IN.equals((Object)exchange.getPhase())) {
            return;
        }
        TransactionHelper txHelper = new TransactionHelper();
        Context context = exchange.getContext();
        ServiceOperation serviceOperation = exchange.getContract().getProviderOperation();
        ProcessActionModel processActionModel = this._actionModels.get(serviceOperation.getName());
        ProcessActionType processActionType = this.getProcessActionType(context, processActionModel);
        Message messageIn = exchange.getMessage();
        Integer sessionId = this.getSessionId(context, this._sessionId);
        Long processInstanceId = null;
        ProcessInstance processInstance = null;
        switch (processActionType) {
            case START_PROCESS: {
                if (this._processId != null) {
                    this._processLock.lock();
                    try {
                        txHelper.beginUserTransaction();
                        StatefulKnowledgeSession ksessionStateful = this.getStatefulSession(sessionId);
                        sessionId = ksessionStateful.getId();
                        HashMap<String, Object> parameters = new HashMap<String, Object>();
                        HashMap<String, Object> vars = new HashMap<String, Object>();
                        Object messageContentIn = messageIn.getContent();
                        if (messageContentIn != null) {
                            parameters.put(this._messageContentInName, messageContentIn);
                            vars.put(this._messageContentInName, messageContentIn);
                        }
                        vars.put("exchange", exchange);
                        vars.put("message", messageIn);
                        for (Map.Entry<String, Expression> pe : this._parameterExpressions.entrySet()) {
                            vars.put("context", new ContextMap(context, this._parameterContextScopes.get(pe.getKey())));
                            Object parameter = pe.getValue().evaluate(vars);
                            parameters.put(pe.getKey(), parameter);
                        }
                        processInstance = ksessionStateful.startProcess(this._processId, parameters);
                        processInstanceId = processInstance.getId();
                        txHelper.commitUserTransaction();
                        break;
                    }
                    catch (RuntimeException re) {
                        txHelper.rollbackUserTransaction();
                        throw re;
                    }
                    finally {
                        this._processLock.unlock();
                    }
                }
                this.throwNullParameterException(processActionType, ProcessConstants.PROCESS_ID_VAR);
                break;
            }
            case SIGNAL_EVENT: {
                StatefulKnowledgeSession ksessionStateful;
                String processEventType = this.getProcessEventType(context, processActionModel);
                Object processEvent = this.getProcessEvent(context, messageIn);
                processInstanceId = this.getProcessInstanceId(context);
                if (processInstanceId != null) {
                    this._processLock.lock();
                    try {
                        txHelper.beginUserTransaction();
                        ksessionStateful = this.getStatefulSession(sessionId);
                        sessionId = ksessionStateful.getId();
                        ksessionStateful.signalEvent(processEventType, processEvent, processInstanceId.longValue());
                        txHelper.commitUserTransaction();
                        break;
                    }
                    catch (RuntimeException re) {
                        txHelper.rollbackUserTransaction();
                        throw re;
                    }
                    finally {
                        this._processLock.unlock();
                    }
                }
                this.throwNullParameterException(processActionType, ProcessConstants.PROCESS_INSTANCE_ID_VAR);
                break;
            }
            case ABORT_PROCESS_INSTANCE: {
                StatefulKnowledgeSession ksessionStateful;
                processInstanceId = this.getProcessInstanceId(context);
                if (processInstanceId != null) {
                    this._processLock.lock();
                    try {
                        txHelper.beginUserTransaction();
                        ksessionStateful = this.getStatefulSession(sessionId);
                        sessionId = ksessionStateful.getId();
                        ksessionStateful.abortProcessInstance(processInstanceId.longValue());
                        txHelper.commitUserTransaction();
                        break;
                    }
                    catch (RuntimeException re) {
                        txHelper.rollbackUserTransaction();
                        throw re;
                    }
                    finally {
                        this._processLock.unlock();
                    }
                }
                this.throwNullParameterException(processActionType, ProcessConstants.PROCESS_INSTANCE_ID_VAR);
            }
        }
        if (processInstanceId != null) {
            ExchangePattern exchangePattern;
            context.setProperty(ProcessConstants.PROCESS_INSTANCE_ID_VAR, (Object)processInstanceId, Scope.EXCHANGE);
            if (this._persistent) {
                context.setProperty(ProcessConstants.SESSION_ID_VAR, (Object)sessionId, Scope.EXCHANGE);
            }
            if (ExchangePattern.IN_OUT.equals((Object)(exchangePattern = serviceOperation.getExchangePattern()))) {
                Map piVars;
                Message messageOut = exchange.createMessage();
                Object messageContentOut = null;
                this._processLock.lock();
                try {
                    txHelper.beginUserTransaction();
                    if (processInstance == null) {
                        StatefulKnowledgeSession ksessionStateful = this.getStatefulSession(sessionId);
                        processInstance = ksessionStateful.getProcessInstance(processInstanceId.longValue());
                    }
                    if (processInstance != null) {
                        messageContentOut = ((WorkflowProcessInstance)processInstance).getVariable(this._messageContentOutName);
                    }
                    txHelper.commitUserTransaction();
                }
                catch (RuntimeException re) {
                    txHelper.rollbackUserTransaction();
                    throw re;
                }
                finally {
                    this._processLock.unlock();
                }
                if (messageContentOut != null) {
                    messageOut.setContent(messageContentOut);
                }
                HashMap<String, Object> vars = new HashMap<String, Object>();
                if (processInstance instanceof WorkflowProcessInstanceImpl && (piVars = ((WorkflowProcessInstanceImpl)processInstance).getVariables()) != null) {
                    vars.putAll(piVars);
                }
                vars.put("exchange", exchange);
                vars.put("message", messageOut);
                for (Map.Entry<String, Expression> re : this._resultExpressions.entrySet()) {
                    vars.put("context", new ContextMap(context, this._resultContextScopes.get(re.getKey())));
                    Object result = re.getValue().evaluate(vars);
                    if (re.getKey().startsWith(IGNORE_VARIABLE_PREFIX)) continue;
                    context.setProperty(re.getKey(), result, Scope.EXCHANGE);
                }
                exchange.send(messageOut);
            }
        }
    }

    public void stop() {
        this.disposeStatefulSession(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this._kbase = null;
        this._parameterContextScopes.clear();
        this._parameterExpressions.clear();
        this._resultContextScopes.clear();
        this._resultExpressions.clear();
        this._taskHandlers.clear();
        this._taskHandlerModels.clear();
        this._actionModels.clear();
        this._messageContentInName = null;
        this._messageContentOutName = null;
        if (this._entityManagerFactory != null) {
            try {
                if (this._entityManagerFactory.isOpen()) {
                    this._entityManagerFactory.close();
                }
            }
            catch (Throwable t) {
                LOGGER.error((Object)"Problem closing EntityManagerFactory", t);
            }
            finally {
                this._entityManagerFactory = null;
            }
        }
        this._processId = null;
        this._persistent = false;
        this._sessionId = null;
        if (this._kagent != null) {
            try {
                this._kagent.dispose();
            }
            catch (Throwable t) {
                LOGGER.error((Object)"Problem disposing KnowledgeAgent", t);
            }
            finally {
                this._kagent = null;
            }
        }
        this._componentImplementationConfig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatefulKnowledgeSession getStatefulSession(Integer sessionId) {
        this._stateLock.lock();
        try {
            if (this._ksession != null && sessionId != null && this._ksession.getId() != sessionId.intValue()) {
                LOGGER.info((Object)("stateful knowledge session with id: " + this._ksession.getId() + " does not match requested session id: " + sessionId + " (will dispose and load)"));
                this.disposeStatefulSession(false);
            }
            if (this._ksession == null) {
                this._ksession = this._persistent ? (sessionId != null ? JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KnowledgeBase)this._kbase, (KnowledgeSessionConfiguration)this._ksessionConfig, (Environment)this._environment) : JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)this._kbase, (KnowledgeSessionConfiguration)this._ksessionConfig, (Environment)this._environment)) : this._kbase.newStatefulKnowledgeSession(this._ksessionConfig, this._environment);
                this._klogger = Audits.getLogger((AuditModel)this._audit, (KnowledgeRuntimeEventManager)this._ksession);
                this._ksession.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

                    public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
                        ((StatefulKnowledgeSession)event.getKnowledgeRuntime()).fireAllRules();
                    }
                });
                Events.addEventListeners((ComponentImplementationConfig)this._componentImplementationConfig, (KnowledgeRuntimeEventManager)this._ksession);
                DroolsTaskManager tm = new DroolsTaskManager((ProcessRuntime)this._ksession);
                for (TaskHandlerModel thm : this._taskHandlerModels) {
                    TaskHandler th = (TaskHandler)Construction.construct(thm.getClazz(this._componentImplementationConfig.getLoader()));
                    String name = thm.getName();
                    if (name != null) {
                        th.setName(name);
                    }
                    th.setMessageContentInName(this._messageContentInName);
                    th.setMessageContentOutName(this._messageContentOutName);
                    th.setTargetNamespace(this._targetNamespace);
                    th.setServiceDomain(this._serviceDomain);
                    tm.registerHandler(th);
                    th.init();
                    this._taskHandlers.add(th);
                }
            }
            StatefulKnowledgeSession statefulKnowledgeSession = this._ksession;
            return statefulKnowledgeSession;
        }
        finally {
            this._stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeStatefulSession(boolean useStateLock) {
        block26: {
            if (useStateLock) {
                this._stateLock.lock();
            }
            try {
                for (TaskHandler th : this._taskHandlers) {
                    try {
                        th.destroy();
                    }
                    catch (Throwable t) {
                        LOGGER.error((Object)("problem destroying TaskHandler: " + th.getName()), t);
                    }
                }
                if (this._ksession == null) break block26;
                try {
                    this._ksession.halt();
                }
                finally {
                    try {
                        this._ksession.dispose();
                    }
                    finally {
                        this._ksession = null;
                        if (this._klogger != null) {
                            try {
                                this._klogger.close();
                            }
                            finally {
                                this._klogger = null;
                            }
                        }
                    }
                }
            }
            finally {
                if (useStateLock) {
                    this._stateLock.unlock();
                }
            }
        }
    }

    private class TransactionHelper {
        private UserTransaction _userTx = null;
        private boolean _isInitiator = false;

        private TransactionHelper() {
        }

        UserTransaction beginUserTransaction() throws HandlerException {
            if (DroolsBPMExchangeHandler.this._persistent) {
                try {
                    this._userTx = AS7TransactionManagerLookup.getUserTransaction();
                    if (this._userTx.getStatus() == 6) {
                        this._userTx.begin();
                        this._isInitiator = true;
                    }
                }
                catch (SystemException se) {
                    throw new HandlerException("UserTransaction begin failed", (Throwable)se);
                }
                catch (NotSupportedException nse) {
                    throw new HandlerException("UserTransaction begin failed", (Throwable)nse);
                }
            }
            return this._userTx;
        }

        void commitUserTransaction() throws HandlerException {
            if (this._isInitiator) {
                try {
                    this._userTx.commit();
                }
                catch (SystemException se) {
                    throw new HandlerException("UserTransaction commit failed", (Throwable)se);
                }
                catch (HeuristicRollbackException hre) {
                    throw new HandlerException("UserTransaction commit failed", (Throwable)hre);
                }
                catch (HeuristicMixedException hme) {
                    throw new HandlerException("UserTransaction commit failed", (Throwable)hme);
                }
                catch (RollbackException re) {
                    throw new HandlerException("UserTransaction commit failed", (Throwable)re);
                }
            }
        }

        void rollbackUserTransaction() throws HandlerException {
            if (this._isInitiator) {
                try {
                    this._userTx.rollback();
                }
                catch (SystemException se) {
                    throw new HandlerException("UserTransaction rollback failed", (Throwable)se);
                }
            }
            if (this._userTx != null) {
                try {
                    this._userTx.setRollbackOnly();
                }
                catch (SystemException se) {
                    throw new HandlerException("UserTransaction setRollbackOnly failed", (Throwable)se);
                }
            }
        }
    }
}

