/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.task.work.jbpm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.marshalling.ObjectMarshallingStrategyAcceptor;
import org.drools.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeRuntime;
import org.jbpm.eventmessaging.EventKey;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.eventmessaging.Payload;
import org.jbpm.process.workitem.wsht.GenericHTWorkItemHandler;
import org.jbpm.process.workitem.wsht.MinaHTWorkItemHandler;
import org.jbpm.task.Content;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.event.TaskCompletedEvent;
import org.jbpm.task.event.TaskEvent;
import org.jbpm.task.event.TaskEventKey;
import org.jbpm.task.event.TaskFailedEvent;
import org.jbpm.task.event.TaskSkippedEvent;
import org.jbpm.task.service.responsehandlers.AbstractBaseResponseHandler;
import org.jbpm.task.utils.ContentMarshallerContext;
import org.jbpm.task.utils.ContentMarshallerHelper;
import org.jbpm.task.utils.MarshalledContentWrapper;
import org.switchyard.common.type.Classes;
import org.switchyard.common.type.reflect.FieldAccess;

public class JBPMHTWorkItemHandler
extends MinaHTWorkItemHandler {
    private static final Logger LOGGER = Logger.getLogger(JBPMHTWorkItemHandler.class);

    JBPMHTWorkItemHandler(KnowledgeRuntime kruntime) {
        super(kruntime);
    }

    private void registerTaskEvents() {
        TaskCompletedHandler eventResponseHandler = new TaskCompletedHandler();
        TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, -1L);
        this.getClient().registerForEvent((EventKey)key, false, (EventResponseHandler)eventResponseHandler);
        this.eventHandlers.put(key, eventResponseHandler);
        key = new TaskEventKey(TaskFailedEvent.class, -1L);
        this.getClient().registerForEvent((EventKey)key, false, (EventResponseHandler)eventResponseHandler);
        this.eventHandlers.put(key, eventResponseHandler);
        key = new TaskEventKey(TaskSkippedEvent.class, -1L);
        this.getClient().registerForEvent((EventKey)key, false, (EventResponseHandler)eventResponseHandler);
        this.eventHandlers.put(key, eventResponseHandler);
    }

    public void connect() {
        if (this.getClient() != null && !this.isConnected()) {
            boolean connected = this.getClient().connect(this.getIpAddress(), this.getPort());
            FieldAccess connectedAccess = new FieldAccess(GenericHTWorkItemHandler.class, "connected");
            connectedAccess.write((Object)this, (Object)connected);
            if (!this.isConnected()) {
                throw new IllegalArgumentException("Could not connect task client: on ip: " + this.getIpAddress() + " - port: " + this.getPort());
            }
            this.registerTaskEvents();
        }
    }

    private static Object unmarshall(String type, byte[] content, ContentMarshallerContext marshallerContext, Environment env) {
        ObjectMarshallingStrategy[] strats = null;
        strats = env != null && env.get("drools.marshalling.ObjectMarshallingStrategies") != null ? (ObjectMarshallingStrategy[])env.get("drools.marshalling.ObjectMarshallingStrategies") : (!marshallerContext.getStrategies().isEmpty() ? (ObjectMarshallingStrategy[])marshallerContext.getStrategies().toArray() : new ObjectMarshallingStrategy[]{new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        HashMap data = null;
        Object selectedStrat = null;
        for (ObjectMarshallingStrategy strat : strats) {
            if (!strat.getClass().getCanonicalName().equals(type)) continue;
            selectedStrat = strat;
        }
        ObjectMarshallingStrategy.Context context = (ObjectMarshallingStrategy.Context)marshallerContext.strategyContext.get(selectedStrat.getClass());
        try {
            if (marshallerContext.isUseMarshal()) {
                data = selectedStrat.unmarshal(context, null, content, ContentMarshallerHelper.class.getClassLoader());
            } else {
                ByteArrayInputStream bs = new ByteArrayInputStream(content);
                ObjectInputStream oIn = new ObjectInputStream(bs){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                        Class<?> clazz = Classes.forName((String)desc.getName(), this.getClass());
                        return clazz != null ? clazz : super.resolveClass(desc);
                    }
                };
                data = selectedStrat.read(oIn);
                oIn.close();
                bs.close();
            }
            if (data instanceof Map) {
                ByteArrayInputStream bs = null;
                ObjectInputStream oIn = null;
                HashMap localData = new HashMap();
                for (Object key : ((Map)data).keySet()) {
                    MarshalledContentWrapper value = (MarshalledContentWrapper)((Map)data).get(key);
                    Object unmarshalledObj = null;
                    for (ObjectMarshallingStrategy strat : strats) {
                        if (!strat.getClass().getCanonicalName().equals(value.getMarshaller())) continue;
                        selectedStrat = strat;
                    }
                    context = (ObjectMarshallingStrategy.Context)marshallerContext.strategyContext.get(selectedStrat.getClass());
                    if (marshallerContext.isUseMarshal()) {
                        unmarshalledObj = selectedStrat.unmarshal(context, null, value.getContent(), ContentMarshallerHelper.class.getClassLoader());
                    } else {
                        bs = new ByteArrayInputStream(value.getContent());
                        oIn = new ObjectInputStream(bs){

                            @Override
                            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                                Class<?> clazz = Classes.forName((String)desc.getName(), this.getClass());
                                return clazz != null ? clazz : super.resolveClass(desc);
                            }
                        };
                        unmarshalledObj = selectedStrat.read(oIn);
                        oIn.close();
                        bs.close();
                    }
                    localData.put(key, unmarshalledObj);
                }
                data = localData;
            }
        }
        catch (IOException ex) {
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return data;
    }

    private final class TaskCompletedHandler
    extends AbstractBaseResponseHandler
    implements EventResponseHandler {
        private TaskCompletedHandler() {
        }

        public void execute(Payload payload) {
            TaskEvent event = (TaskEvent)payload.get();
            final long taskId = event.getTaskId();
            if (JBPMHTWorkItemHandler.this.isLocal()) {
                this.handleCompletedTask(taskId);
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        TaskCompletedHandler.this.handleCompletedTask(taskId);
                    }
                };
                new Thread(runnable).start();
            }
        }

        public boolean isRemove() {
            return false;
        }

        public void handleCompletedTask(long taskId) {
            Task task = JBPMHTWorkItemHandler.this.getClient().getTask(taskId);
            long workItemId = task.getTaskData().getWorkItemId();
            if (task.getTaskData().getStatus() == Status.Completed) {
                String userId = task.getTaskData().getActualOwner().getId();
                HashMap<String, Object> results = new HashMap<String, Object>();
                results.put("ActorId", userId);
                long contentId = task.getTaskData().getOutputContentId();
                if (contentId != -1L) {
                    Content content = JBPMHTWorkItemHandler.this.getClient().getContent(contentId);
                    Object result = JBPMHTWorkItemHandler.unmarshall(task.getTaskData().getDocumentType(), content.getContent(), JBPMHTWorkItemHandler.this.marshallerContext, JBPMHTWorkItemHandler.this.session.getEnvironment());
                    results.put("Result", result);
                    if (result instanceof Map) {
                        Map map = (Map)result;
                        for (Map.Entry entry : map.entrySet()) {
                            if (!(entry.getKey() instanceof String)) continue;
                            results.put((String)entry.getKey(), entry.getValue());
                        }
                    }
                    JBPMHTWorkItemHandler.this.session.getWorkItemManager().completeWorkItem(task.getTaskData().getWorkItemId(), results);
                } else {
                    JBPMHTWorkItemHandler.this.session.getWorkItemManager().completeWorkItem(workItemId, results);
                }
            } else {
                JBPMHTWorkItemHandler.this.session.getWorkItemManager().abortWorkItem(workItemId);
            }
        }
    }
}

