/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.service;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.kie.runtime.process.ProcessRuntime;
import org.kie.runtime.process.WorkItem;
import org.kie.runtime.process.WorkItemHandler;
import org.kie.runtime.process.WorkItemManager;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceInvoker;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceRequest;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceResponse;

public class SwitchYardServiceWorkItemHandler
implements WorkItemHandler {
    private static final Logger LOGGER = Logger.getLogger(SwitchYardServiceWorkItemHandler.class);
    public static final String SWITCHYARD_SERVICE = "SwitchYard Service";
    public static final String SERVICE_NAME = "ServiceName";
    public static final String SERVICE_OPERATION_NAME = "ServiceOperationName";
    public static final String CONTENT_INPUT_NAME = "ContentInputName";
    public static final String CONTENT_OUTPUT_NAME = "ContentOutputName";
    public static final String FAULT_RESULT_NAME = "FaultResultName";
    public static final String FAULT_SIGNAL_ID = "FaultSignalId";
    public static final String FAULT_WORK_ITEM_ACTION = "FaultWorkItemAction";
    private String _name;
    private SwitchYardServiceInvoker _invoker;
    private ProcessRuntime _processRuntime;

    public SwitchYardServiceWorkItemHandler() {
        this.setName(SWITCHYARD_SERVICE);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public SwitchYardServiceInvoker getInvoker() {
        return this._invoker;
    }

    public void setInvoker(SwitchYardServiceInvoker invoker) {
        this._invoker = invoker;
    }

    public ProcessRuntime getProcessRuntime() {
        return this._processRuntime;
    }

    public void setProcessRuntime(ProcessRuntime processRuntime) {
        this._processRuntime = processRuntime;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        Object fault;
        Map parameters = workItem.getParameters();
        Object contentInput = null;
        String contentInputName = this.getContentInputName(parameters);
        if (contentInputName != null) {
            contentInput = parameters.get(contentInputName);
        }
        SwitchYardServiceRequest request = new SwitchYardServiceRequest(this.getServiceName(parameters), this.getServiceOperationName(parameters), contentInput, parameters);
        SwitchYardServiceResponse response = this.getInvoker().invoke(request);
        HashMap<String, Object> results = workItem.getResults();
        if (results == null) {
            results = new HashMap<String, Object>();
        }
        results.putAll(response.getContext());
        String contentOutputName = this.getContentOutputName(parameters);
        if (contentOutputName != null) {
            results.put(contentOutputName, response.getContent());
        }
        if ((fault = response.getFault()) == null) {
            manager.completeWorkItem(workItem.getId(), results);
        } else {
            FaultWorkItemAction faultWorkItemAction;
            String faultSignalId;
            if (fault instanceof Throwable) {
                Throwable t = (Throwable)fault;
                LOGGER.error((Object)("Fault encountered: " + t.getMessage()), t);
            } else {
                LOGGER.error((Object)("Fault encountered: " + fault));
            }
            String faultResultName = this.getFaultResultName(parameters);
            if (faultResultName != null) {
                results.put(faultResultName, fault);
            }
            if ((faultSignalId = this.getFaultSignalId(parameters)) != null) {
                this.getProcessRuntime().signalEvent(faultSignalId, fault, workItem.getProcessInstanceId());
            }
            if ((faultWorkItemAction = this.getFaultWorkItemAction(parameters)) != null) {
                switch (faultWorkItemAction) {
                    case ABORT: {
                        manager.abortWorkItem(workItem.getId());
                        break;
                    }
                    case COMPLETE: {
                        manager.completeWorkItem(workItem.getId(), results);
                    }
                }
            }
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    protected QName getServiceName(Map<String, Object> parameters) {
        return this.getQName(SERVICE_NAME, parameters, null);
    }

    protected String getServiceOperationName(Map<String, Object> parameters) {
        return this.getString(SERVICE_OPERATION_NAME, parameters, null);
    }

    protected String getContentInputName(Map<String, Object> parameters) {
        return this.getString(CONTENT_INPUT_NAME, parameters, "contentInput");
    }

    protected String getContentOutputName(Map<String, Object> parameters) {
        return this.getString(CONTENT_OUTPUT_NAME, parameters, "contentOutput");
    }

    private String getFaultResultName(Map<String, Object> parameters) {
        return this.getString(FAULT_RESULT_NAME, parameters, null);
    }

    private String getFaultSignalId(Map<String, Object> parameters) {
        return this.getString(FAULT_SIGNAL_ID, parameters, null);
    }

    private FaultWorkItemAction getFaultWorkItemAction(Map<String, Object> parameters) {
        String s = this.getString(FAULT_WORK_ITEM_ACTION, parameters, null);
        if (s != null) {
            try {
                return FaultWorkItemAction.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                LOGGER.warn((Object)String.format("Unknown %s: %s", FaultWorkItemAction.class.getSimpleName(), iae.getMessage()));
            }
        }
        return null;
    }

    protected QName getQName(String parameterName, Map<String, Object> parameters, QName defaultValue) {
        Object serviceName = parameters.get(parameterName);
        if (serviceName instanceof QName) {
            return (QName)serviceName;
        }
        if (serviceName instanceof String) {
            return XMLHelper.createQName((String)((String)serviceName));
        }
        return defaultValue;
    }

    protected String getString(String parameterName, Map<String, Object> parameters, String defaultValue) {
        String value = null;
        Object p = parameters.get(parameterName);
        if (p != null) {
            value = Strings.trimToNull((String)String.valueOf(p));
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private static enum FaultWorkItemAction {
        ABORT,
        COMPLETE;

    }
}

