/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.config.model;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import org.jbpm.process.workitem.wsht.AbstractHTWorkItemHandler;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.classpath.ClasspathScanner;
import org.switchyard.common.type.classpath.Filter;
import org.switchyard.common.type.classpath.IsAnnotationPresentFilter;
import org.switchyard.component.bpm.BPMActionType;
import org.switchyard.component.bpm.annotation.AbortProcessInstance;
import org.switchyard.component.bpm.annotation.BPM;
import org.switchyard.component.bpm.annotation.SignalEvent;
import org.switchyard.component.bpm.annotation.StartProcess;
import org.switchyard.component.bpm.annotation.WorkItemHandler;
import org.switchyard.component.bpm.config.model.WorkItemHandlersModel;
import org.switchyard.component.bpm.config.model.v1.V1BPMActionModel;
import org.switchyard.component.bpm.config.model.v1.V1BPMComponentImplementationModel;
import org.switchyard.component.bpm.config.model.v1.V1WorkItemHandlerModel;
import org.switchyard.component.bpm.config.model.v1.V1WorkItemHandlersModel;
import org.switchyard.component.bpm.service.SwitchYardServiceWorkItemHandler;
import org.switchyard.component.bpm.util.WorkItemHandlers;
import org.switchyard.component.common.knowledge.annotation.Mapping;
import org.switchyard.component.common.knowledge.config.model.ActionModel;
import org.switchyard.component.common.knowledge.config.model.ActionsModel;
import org.switchyard.component.common.knowledge.config.model.KnowledgeSwitchYardScanner;
import org.switchyard.component.common.knowledge.config.model.v1.V1ActionsModel;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1CompositeModel;
import org.switchyard.config.model.composite.v1.V1InterfaceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.metadata.java.JavaService;

public class BPMSwitchYardScanner
extends KnowledgeSwitchYardScanner {
    private static final IsAnnotationPresentFilter START_PROCESS_FILTER = new IsAnnotationPresentFilter(StartProcess.class);
    private static final IsAnnotationPresentFilter SIGNAL_EVENT_FILTER = new IsAnnotationPresentFilter(SignalEvent.class);
    private static final IsAnnotationPresentFilter ABORT_PROCESS_INSTANCE_FILTER = new IsAnnotationPresentFilter(AbortProcessInstance.class);
    private final IsAnnotationPresentFilter _bpmFilter = new IsAnnotationPresentFilter(BPM.class);

    public ScannerOutput<SwitchYardModel> scan(ScannerInput<SwitchYardModel> input) throws IOException {
        V1SwitchYardModel switchyardModel = new V1SwitchYardModel();
        V1CompositeModel compositeModel = new V1CompositeModel();
        compositeModel.setName(input.getName());
        ClasspathScanner bpmScanner = new ClasspathScanner((Filter)this._bpmFilter);
        for (URL url : input.getURLs()) {
            bpmScanner.scan(url);
        }
        List bpmClasses = this._bpmFilter.getMatchedTypes();
        for (Class bpmClass : bpmClasses) {
            compositeModel.addComponent(this.scan(bpmClass));
        }
        if (!compositeModel.getModelChildren().isEmpty()) {
            switchyardModel.setComposite((CompositeModel)compositeModel);
        }
        return new ScannerOutput().setModel((Model)switchyardModel);
    }

    public ComponentModel scan(Class<?> bpmClass) throws IOException {
        String processId;
        BPM bpm = bpmClass.getAnnotation(BPM.class);
        if (bpm == null) {
            throw new IOException(bpmClass.getName() + " is missing the @BPM annotation.");
        }
        Class<?> bpmInterface = bpm.value();
        if (BPM.UndefinedBPMInterface.class.equals(bpmInterface)) {
            bpmInterface = bpmClass;
        }
        if (!bpmInterface.isInterface()) {
            throw new IOException(bpmInterface.getName() + " is a class. @BPM only allowed on interfaces.");
        }
        String bpmName = Strings.trimToNull((String)bpm.name());
        if (bpmName == null) {
            bpmName = bpmInterface.getSimpleName();
        }
        V1ComponentModel componentModel = new V1ComponentModel();
        componentModel.setName(bpmName);
        V1BPMComponentImplementationModel componentImplementationModel = new V1BPMComponentImplementationModel();
        boolean persistent = bpm.persistent();
        if (persistent) {
            componentImplementationModel.setPersistent(persistent);
        }
        if ("".equals(processId = bpm.processId())) {
            processId = bpmName;
        }
        componentImplementationModel.setProcessId(processId);
        V1ActionsModel actionsModel = new V1ActionsModel("urn:switchyard-component-bpm:config:1.0");
        JavaService javaService = JavaService.fromClass(bpmInterface);
        for (Method method : bpmClass.getDeclaredMethods()) {
            ServiceOperation serviceOperation;
            BPMActionType actionType = null;
            String id = null;
            Mapping[] globalMappingAnnotations = null;
            Mapping[] inputMappingAnnotations = null;
            Mapping[] outputMappingAnnotations = null;
            if (START_PROCESS_FILTER.matches(method)) {
                actionType = BPMActionType.START_PROCESS;
                StartProcess startProcessAnnotation = method.getAnnotation(StartProcess.class);
                globalMappingAnnotations = startProcessAnnotation.globals();
                inputMappingAnnotations = startProcessAnnotation.inputs();
                outputMappingAnnotations = startProcessAnnotation.outputs();
            } else if (SIGNAL_EVENT_FILTER.matches(method)) {
                actionType = BPMActionType.SIGNAL_EVENT;
                SignalEvent signalEventAnnotation = method.getAnnotation(SignalEvent.class);
                globalMappingAnnotations = signalEventAnnotation.globals();
                inputMappingAnnotations = signalEventAnnotation.inputs();
                outputMappingAnnotations = signalEventAnnotation.outputs();
                id = Strings.trimToNull((String)signalEventAnnotation.id());
            } else if (ABORT_PROCESS_INSTANCE_FILTER.matches(method)) {
                actionType = BPMActionType.ABORT_PROCESS_INSTANCE;
                AbortProcessInstance abortProcessInstanceAnnotation = method.getAnnotation(AbortProcessInstance.class);
                globalMappingAnnotations = abortProcessInstanceAnnotation.globals();
                inputMappingAnnotations = abortProcessInstanceAnnotation.inputs();
                outputMappingAnnotations = abortProcessInstanceAnnotation.outputs();
            }
            if (actionType == null || (serviceOperation = javaService.getOperation(method.getName())) == null) continue;
            V1BPMActionModel actionModel = new V1BPMActionModel();
            actionModel.setId(id);
            actionModel.setOperation(serviceOperation.getName());
            actionModel.setType(actionType);
            actionModel.setGlobals(this.toMappingsModel(globalMappingAnnotations, "urn:switchyard-component-bpm:config:1.0", "globals"));
            actionModel.setInputs(this.toMappingsModel(inputMappingAnnotations, "urn:switchyard-component-bpm:config:1.0", "inputs"));
            actionModel.setOutputs(this.toMappingsModel(outputMappingAnnotations, "urn:switchyard-component-bpm:config:1.0", "outputs"));
            actionsModel.addAction((ActionModel)actionModel);
        }
        if (!actionsModel.getActions().isEmpty()) {
            componentImplementationModel.setActions((ActionsModel)actionsModel);
        }
        componentImplementationModel.setChannels(this.toChannelsModel(bpm.channels(), "urn:switchyard-component-bpm:config:1.0", (ComponentModel)componentModel));
        componentImplementationModel.setListeners(this.toListenersModel(bpm.listeners(), "urn:switchyard-component-bpm:config:1.0"));
        componentImplementationModel.setLoggers(this.toLoggersModel(bpm.loggers(), "urn:switchyard-component-bpm:config:1.0"));
        componentImplementationModel.setManifest(this.toManifestModel(bpm.manifest(), "urn:switchyard-component-bpm:config:1.0"));
        componentImplementationModel.setProperties(this.toPropertiesModel(bpm.properties(), "urn:switchyard-component-bpm:config:1.0"));
        componentImplementationModel.setWorkItemHandlers(this.toWorkItemHandlersModel(bpm.workItemHandlers()));
        componentModel.setImplementation((ComponentImplementationModel)componentImplementationModel);
        V1ComponentServiceModel componentServiceModel = new V1ComponentServiceModel();
        V1InterfaceModel interfaceModel = new V1InterfaceModel("java");
        interfaceModel.setInterface(bpmInterface.getName());
        componentServiceModel.setInterface((InterfaceModel)interfaceModel);
        componentServiceModel.setName(bpmName);
        componentModel.addService((ComponentServiceModel)componentServiceModel);
        return componentModel;
    }

    private WorkItemHandlersModel toWorkItemHandlersModel(WorkItemHandler[] workItemHandlerAnnotations) {
        if (workItemHandlerAnnotations == null || workItemHandlerAnnotations.length == 0) {
            return null;
        }
        V1WorkItemHandlersModel workItemHandlersModel = new V1WorkItemHandlersModel();
        for (WorkItemHandler workItemHandlerAnnotation : workItemHandlerAnnotations) {
            V1WorkItemHandlerModel workItemHandlerModel = new V1WorkItemHandlerModel();
            Class<? extends org.kie.runtime.process.WorkItemHandler> clazz = workItemHandlerAnnotation.value();
            workItemHandlerModel.setClazz(clazz);
            String name = workItemHandlerAnnotation.name();
            if ("".equals(name)) {
                org.kie.runtime.process.WorkItemHandler wih = WorkItemHandlers.newWorkItemHandler(clazz, null);
                if (wih instanceof SwitchYardServiceWorkItemHandler) {
                    SwitchYardServiceWorkItemHandler syswih = (SwitchYardServiceWorkItemHandler)wih;
                    if (syswih.getName() != null) {
                        name = syswih.getName();
                    }
                } else if (wih instanceof AbstractHTWorkItemHandler) {
                    name = "Human Task";
                }
            }
            if ("".equals(name)) {
                name = clazz.getSimpleName();
            }
            workItemHandlerModel.setName(name);
            workItemHandlersModel.addWorkItemHandler(workItemHandlerModel);
        }
        return workItemHandlersModel;
    }
}

