/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.runtime;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.persistence.EntityManagerFactory;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.shared.services.api.JbpmServicesTransactionManager;
import org.jbpm.shared.services.impl.events.JbpmServicesEventListener;
import org.kie.api.runtime.Environment;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.EventService;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.UserGroupCallback;
import org.kie.internal.task.api.model.NotificationEvent;
import org.switchyard.component.bpm.transaction.AS7TransactionHelper;

public interface BPMTaskService
extends InternalTaskService,
EventService<JbpmServicesEventListener<NotificationEvent>, JbpmServicesEventListener<Task>> {

    public static final class Factory {
        public static final BPMTaskService newTaskService(Environment environment, EntityManagerFactory entityManagerFactory, JbpmServicesTransactionManager jbpmServicesTransactionManager, UserGroupCallback userGroupCallback, ClassLoader loader) {
            InternalTaskService internalTaskService = (InternalTaskService)HumanTaskServiceFactory.newTaskServiceConfigurator().entityManagerFactory(entityManagerFactory).transactionManager(jbpmServicesTransactionManager).userGroupCallback(userGroupCallback).getTaskService();
            String deploymentId = (String)environment.get("deploymentId");
            internalTaskService.addMarshallerContext(deploymentId, new ContentMarshallerContext(environment, loader));
            TaskServiceInvocationHandler invocationHandler = new TaskServiceInvocationHandler(internalTaskService);
            return (BPMTaskService)Proxy.newProxyInstance(BPMTaskService.class.getClassLoader(), new Class[]{BPMTaskService.class}, (InvocationHandler)invocationHandler);
        }

        private static final class TaskServiceInvocationHandler
        implements InvocationHandler {
            private final InternalTaskService _internalTaskService;

            private TaskServiceInvocationHandler(InternalTaskService internalTaskService) {
                this._internalTaskService = internalTaskService;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object ret;
                AS7TransactionHelper utx = new AS7TransactionHelper(true);
                try {
                    utx.begin();
                    ret = method.invoke((Object)this._internalTaskService, args);
                    utx.commit();
                }
                catch (Throwable t) {
                    utx.rollback();
                    throw t;
                }
                return ret;
            }
        }
    }
}

