/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.transaction;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.hibernate.HibernateException;
import org.jboss.logging.Logger;
import org.switchyard.HandlerException;
import org.switchyard.component.bpm.BPMMessages;

public class AS7TransactionHelper {
    private static final Logger LOGGER = Logger.getLogger(AS7TransactionHelper.class);
    public static final String JNDI_TRANSACTION_MANAGER = "java:jboss/TransactionManager";
    public static final String JNDI_USER_TRANSACTION = "java:jboss/UserTransaction";
    private final boolean _enabled;
    private UserTransaction _userTx = null;
    private boolean _isInitiator = false;

    public AS7TransactionHelper(boolean enabled) {
        this._enabled = enabled;
    }

    public void begin() throws HandlerException {
        if (this._enabled) {
            try {
                this._userTx = AS7TransactionHelper.getUserTransaction();
                if (this._userTx.getStatus() == 6) {
                    this._userTx.begin();
                    this._isInitiator = true;
                }
            }
            catch (SystemException se) {
                throw BPMMessages.MESSAGES.userTransactionBeginFailedSystem(se);
            }
            catch (NotSupportedException nse) {
                throw BPMMessages.MESSAGES.userTransactionBeginFailedNSE(nse);
            }
        }
    }

    public void commit() throws HandlerException {
        if (this._isInitiator) {
            try {
                this._userTx.commit();
            }
            catch (SystemException se) {
                throw BPMMessages.MESSAGES.userTransactionCommitFailedSystem(se);
            }
            catch (HeuristicRollbackException hre) {
                throw BPMMessages.MESSAGES.userTransactionCommitFailedRollback(hre);
            }
            catch (HeuristicMixedException hme) {
                throw BPMMessages.MESSAGES.userTransactionCommitFailedMixed(hme);
            }
            catch (RollbackException re) {
                throw BPMMessages.MESSAGES.userTransactionCommitFailed(re);
            }
        }
    }

    public void rollback() throws HandlerException {
        if (this._isInitiator) {
            try {
                this._userTx.rollback();
            }
            catch (SystemException se) {
                throw BPMMessages.MESSAGES.userTransactionRollbackFailed(se);
            }
        }
        if (this._userTx != null) {
            try {
                this._userTx.setRollbackOnly();
            }
            catch (SystemException se) {
                throw BPMMessages.MESSAGES.userTransactionSetRollbackOnlyFailed(se);
            }
        }
    }

    public static TransactionManager getTransactionManager() {
        return AS7TransactionHelper.getTransactionManager(null);
    }

    public static TransactionManager getTransactionManager(Properties properties) {
        return (TransactionManager)AS7TransactionHelper.jndiLookup(JNDI_TRANSACTION_MANAGER, properties);
    }

    public static UserTransaction getUserTransaction() {
        return (UserTransaction)AS7TransactionHelper.jndiLookup(JNDI_USER_TRANSACTION, null);
    }

    private static Object jndiLookup(String name, Properties properties) {
        InitialContext ctx = null;
        try {
            ctx = properties != null ? new InitialContext(properties) : new InitialContext();
            Object object = ctx.lookup(name);
            return object;
        }
        catch (NamingException ne) {
            LOGGER.error((Object)ne.getMessage());
            throw new HibernateException((Throwable)ne);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable t) {
                    LOGGER.error((Object)t.getMessage());
                }
            }
        }
    }
}

