/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.runtime;

import javax.persistence.EntityManagerFactory;
import org.jbpm.runtime.manager.impl.SimpleRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.mapper.InMemoryMapper;
import org.jbpm.runtime.manager.impl.mapper.JPAMapper;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.internal.runtime.manager.Mapper;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.task.api.UserGroupCallback;

public final class BPMRuntimeEnvironment
implements RuntimeEnvironment {
    private final KieBase _kieBase;
    private final Environment _environment;
    private final KieSessionConfiguration _configuration;
    private final boolean _usePersistence;
    private final RegisterableItemsFactory _registerableItemsFactory;
    private final Mapper _mapper;
    private final UserGroupCallback _userGroupCallback;
    private final ClassLoader _classLoader;

    public BPMRuntimeEnvironment(KieSession kieSession, EntityManagerFactory processEntityManagerFactory, UserGroupCallback userGroupCallback, ClassLoader classLoader) {
        this._kieBase = kieSession.getKieBase();
        this._environment = kieSession.getEnvironment();
        this._configuration = kieSession.getSessionConfiguration();
        this._usePersistence = processEntityManagerFactory != null;
        this._registerableItemsFactory = new SimpleRegisterableItemsFactory();
        this._mapper = this._usePersistence ? new JPAMapper(processEntityManagerFactory) : new InMemoryMapper();
        this._userGroupCallback = userGroupCallback;
        this._classLoader = classLoader;
    }

    public KieBase getKieBase() {
        return this._kieBase;
    }

    public Environment getEnvironment() {
        return this._environment;
    }

    public KieSessionConfiguration getConfiguration() {
        return this._configuration;
    }

    public boolean usePersistence() {
        return this._usePersistence;
    }

    public RegisterableItemsFactory getRegisterableItemsFactory() {
        return this._registerableItemsFactory;
    }

    public Mapper getMapper() {
        return this._mapper;
    }

    public UserGroupCallback getUserGroupCallback() {
        return this._userGroupCallback;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void close() {
    }
}

