/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.atom.model.v1;

import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.switchyard.component.camel.atom.model.CamelAtomBindingModel;
import org.switchyard.component.camel.common.QueryString;
import org.switchyard.component.camel.common.model.consumer.CamelScheduledPollConsumer;
import org.switchyard.component.camel.common.model.v1.V1BaseCamelBindingModel;
import org.switchyard.component.camel.common.model.v1.V1CamelScheduledPollConsumer;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;

public class V1CamelAtomBindingModel
extends V1BaseCamelBindingModel
implements CamelAtomBindingModel {
    public static final String ATOM = "atom";
    private static final String FEED_URI = "feedURI";
    private static final String SPLIT_ENTRIES = "splitEntries";
    private static final String FILTER = "filter";
    private static final String LAST_UPDATE = "lastUpdate";
    private static final String THROTTLE_ENTRIES = "throttleEntries";
    private static final String FEED_HEADER = "feedHeader";
    private static final String SORT_ENTRIES = "sortEntries";
    private CamelScheduledPollConsumer _consume;
    private static DateFormat _dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public V1CamelAtomBindingModel(String namespace) {
        super(ATOM, namespace);
        this.setModelChildrenOrder(new String[]{FEED_URI, SPLIT_ENTRIES, FILTER, LAST_UPDATE, THROTTLE_ENTRIES, FEED_HEADER, SORT_ENTRIES, "consume"});
    }

    public V1CamelAtomBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    @Override
    public URI getFeedURI() {
        String uriStr = this.getConfig(FEED_URI);
        if (uriStr != null) {
            return URI.create(uriStr);
        }
        return null;
    }

    @Override
    public V1CamelAtomBindingModel setFeedURI(URI uri) {
        return (V1CamelAtomBindingModel)this.setConfig(FEED_URI, uri.toString());
    }

    @Override
    public Date getLastUpdate() {
        return this.getDateConfig(LAST_UPDATE, _dateFormat);
    }

    @Override
    public V1CamelAtomBindingModel setLastUpdate(Date date) {
        this.setConfig(LAST_UPDATE, _dateFormat.format(date));
        return this;
    }

    @Override
    public Boolean isFeedHeader() {
        return this.getBooleanConfig(FEED_HEADER);
    }

    @Override
    public V1CamelAtomBindingModel setFeedHeader(Boolean feedHeader) {
        return (V1CamelAtomBindingModel)this.setConfig(FEED_HEADER, feedHeader);
    }

    @Override
    public Boolean isFilter() {
        return this.getBooleanConfig(FILTER);
    }

    @Override
    public V1CamelAtomBindingModel setFilter(Boolean filtered) {
        return (V1CamelAtomBindingModel)this.setConfig(FILTER, filtered);
    }

    @Override
    public Boolean isSortEntries() {
        return this.getBooleanConfig(SORT_ENTRIES);
    }

    @Override
    public V1CamelAtomBindingModel setSortEntries(Boolean sorted) {
        return (V1CamelAtomBindingModel)this.setConfig(SORT_ENTRIES, sorted);
    }

    @Override
    public Boolean isSplitEntries() {
        return this.getBooleanConfig(SPLIT_ENTRIES);
    }

    @Override
    public V1CamelAtomBindingModel setSplitEntries(Boolean split) {
        return (V1CamelAtomBindingModel)this.setConfig(SPLIT_ENTRIES, String.valueOf(split));
    }

    @Override
    public Boolean isThrottleEntries() {
        return this.getBooleanConfig(THROTTLE_ENTRIES);
    }

    @Override
    public V1CamelAtomBindingModel setThrottleEntries(Boolean throttled) {
        return (V1CamelAtomBindingModel)this.setConfig(THROTTLE_ENTRIES, String.valueOf(throttled));
    }

    @Override
    public CamelScheduledPollConsumer getConsumer() {
        if (this._consume == null) {
            Configuration config = this.getModelConfiguration().getFirstChild("consume");
            this._consume = new V1CamelScheduledPollConsumer(config, this.getModelDescriptor());
        }
        return this._consume;
    }

    @Override
    public V1CamelAtomBindingModel setConsumer(CamelScheduledPollConsumer consumer) {
        Configuration config = this.getModelConfiguration().getFirstChild("consume");
        if (config != null) {
            this.getModelConfiguration().removeChildren("consume");
            this.getModelConfiguration().addChild(((V1CamelScheduledPollConsumer)consumer).getModelConfiguration());
        } else {
            this.setChildModel((Model)((V1CamelScheduledPollConsumer)consumer));
        }
        this._consume = consumer;
        return this;
    }

    public URI getComponentURI() {
        Configuration modelConfiguration = this.getModelConfiguration();
        List children = modelConfiguration.getChildren();
        String baseUri = "atom://" + this.getFeedURI();
        QueryString queryStr = new QueryString();
        this.traverseConfiguration(children, queryStr, new String[]{FEED_URI});
        return URI.create(baseUri + queryStr.toString());
    }
}

