/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.jpa.deploy;

import java.util.Map;
import javax.naming.InitialContext;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import org.jboss.logging.Logger;

public final class EntityManagerFactoryLocator {
    private static Logger _logger = Logger.getLogger(EntityManagerFactoryLocator.class);
    public static final String OSGI_PERSISTENCE_PROVIDER_JNDI_NAME = "osgi:service/javax.persistence.spi.PersistenceProvider";
    public static final String OSGI_ENTITY_MANAGER_FACTORY_JNDI_NAME = "osgi:service/javax.persistence.EntityManagerFactory";

    private EntityManagerFactoryLocator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityManagerFactory locateEntityManagerFactory(String unitName, Map<?, ?> props) {
        InitialContext ic = null;
        try {
            ic = new InitialContext();
        }
        catch (Exception e) {
            _logger.debug((Object)e);
            return null;
        }
        try {
            EntityManagerFactory emf = (EntityManagerFactory)EntityManagerFactoryLocator.lookupInJndi(ic, OSGI_ENTITY_MANAGER_FACTORY_JNDI_NAME);
            if (emf != null) {
                EntityManagerFactory entityManagerFactory = emf;
                return entityManagerFactory;
            }
            PersistenceProvider pp = (PersistenceProvider)EntityManagerFactoryLocator.lookupInJndi(ic, OSGI_PERSISTENCE_PROVIDER_JNDI_NAME);
            if (pp != null) {
                EntityManagerFactory entityManagerFactory = pp.createEntityManagerFactory(unitName, props);
                return entityManagerFactory;
            }
        }
        finally {
            try {
                ic.close();
            }
            catch (Exception e) {
                _logger.debug((Object)e);
            }
        }
        return null;
    }

    private static Object lookupInJndi(InitialContext ic, String name) {
        try {
            return ic.lookup(name);
        }
        catch (Exception e) {
            _logger.debug((Object)e);
            return null;
        }
    }
}

