/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.mqtt.deploy;

import javax.xml.namespace.QName;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TryDefinition;
import org.switchyard.ServiceDomain;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.common.type.Classes;
import org.switchyard.component.camel.common.handler.InboundHandler;
import org.switchyard.component.camel.common.handler.MessageComposerProcessor;
import org.switchyard.component.camel.common.handler.OperationSelectorProcessor;
import org.switchyard.component.camel.common.model.CamelBindingModel;
import org.switchyard.component.camel.mqtt.model.CamelMqttBindingModel;

public class CamelMqttInboundHandler
extends InboundHandler<CamelMqttBindingModel> {
    private static final String ORIGINAL_CLASS_LOADER = "org.switchyard.component.camel.mqtt.deploy.CamelMqttInboundHandler.originalClassLoader";

    public CamelMqttInboundHandler(CamelMqttBindingModel camelBindingModel, SwitchYardCamelContext camelContext, QName serviceName, ServiceDomain domain) {
        super((CamelBindingModel)camelBindingModel, camelContext, serviceName, domain);
    }

    protected RouteDefinition createRouteDefinition() {
        RouteDefinition route = new RouteDefinition();
        route.routeId(this.getRouteId()).from(this.getComponentUri().toString());
        ((TryDefinition)((TryDefinition)((TryDefinition)((ProcessorDefinition)((ProcessorDefinition)((TryDefinition)this.addTransactionPolicy(route).doTry().process(new Processor(){

            public void process(Exchange exchange) throws Exception {
                ClassLoader appClassLoader = exchange.getContext().getApplicationContextClassLoader();
                ClassLoader origCl = Classes.setTCCL((ClassLoader)appClassLoader);
                exchange.setProperty(CamelMqttInboundHandler.ORIGINAL_CLASS_LOADER, (Object)origCl);
            }
        })).setProperty("org.switchyard.exchangeGatewayName").simple(((CamelMqttBindingModel)this.getBindingModel()).getName(), String.class)).setProperty("org.switchyard.component.camel.namespace").constant((Object)this.getServiceName().getNamespaceURI())).process((Processor)new MessageComposerProcessor(this.getBindingModel()))).process((Processor)new OperationSelectorProcessor(this.getServiceName(), this.getBindingModel()))).to(this.getSwitchyardEndpointUri())).doFinally().process(new Processor(){

            public void process(Exchange exchange) throws Exception {
                ClassLoader origCl = (ClassLoader)exchange.getProperty(CamelMqttInboundHandler.ORIGINAL_CLASS_LOADER, ClassLoader.class);
                if (origCl != null) {
                    Classes.setTCCL((ClassLoader)origCl);
                }
            }
        });
        return route;
    }
}

