/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.netty.model.v1;

import java.net.URI;
import java.util.List;
import org.switchyard.component.camel.common.QueryString;
import org.switchyard.component.camel.common.model.v1.V1BaseCamelBindingModel;
import org.switchyard.component.camel.netty.model.CamelNettyBindingModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;

public abstract class V1CamelNettyBindingModel
extends V1BaseCamelBindingModel
implements CamelNettyBindingModel {
    public static final String NETTY = "netty";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String RECEIVE_BUFFER_SIZE = "receiveBufferSize";
    private static final String SEND_BUFFER_SIZE = "sendBufferSize";
    private static final String REUSE_ADDRESS = "reuseAddress";
    private static final String ENCODERS = "encoders";
    private static final String DECODERS = "decoders";
    private static final String ALLOW_DEFAULT_CODEC = "allowDefaultCodec";
    private static final String WORKER_COUNT = "workerCount";
    private static final String SYNC = "sync";
    private static final String DISCONNECT = "disconnect";

    protected V1CamelNettyBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    protected V1CamelNettyBindingModel(String name, String namespace) {
        super(name, namespace);
        this.setModelChildrenOrder(new String[]{HOST, PORT, RECEIVE_BUFFER_SIZE, SEND_BUFFER_SIZE, REUSE_ADDRESS, ENCODERS, DECODERS, ALLOW_DEFAULT_CODEC, WORKER_COUNT, SYNC, DISCONNECT});
    }

    @Override
    public String getHost() {
        return this.getConfig(HOST);
    }

    @Override
    public V1CamelNettyBindingModel setHost(String host) {
        return (V1CamelNettyBindingModel)this.setConfig(HOST, host);
    }

    @Override
    public Integer getPort() {
        return this.getIntegerConfig(PORT);
    }

    @Override
    public V1CamelNettyBindingModel setPort(int port) {
        return (V1CamelNettyBindingModel)this.setConfig(PORT, port);
    }

    @Override
    public Long getReceiveBufferSize() {
        return this.getLongConfig(RECEIVE_BUFFER_SIZE);
    }

    @Override
    public V1CamelNettyBindingModel setReceiveBufferSize(Long receiveBufferSize) {
        return (V1CamelNettyBindingModel)this.setConfig(RECEIVE_BUFFER_SIZE, receiveBufferSize);
    }

    @Override
    public Long getSendBufferSize() {
        return this.getLongConfig(SEND_BUFFER_SIZE);
    }

    @Override
    public V1CamelNettyBindingModel setSendBufferSize(Long sendBufferSize) {
        return (V1CamelNettyBindingModel)this.setConfig(SEND_BUFFER_SIZE, sendBufferSize);
    }

    @Override
    public Boolean isReuseAddress() {
        return this.getBooleanConfig(REUSE_ADDRESS);
    }

    @Override
    public V1CamelNettyBindingModel setReuseAddress(Boolean reuseAddress) {
        return (V1CamelNettyBindingModel)this.setConfig(REUSE_ADDRESS, reuseAddress);
    }

    @Override
    public String getEncoders() {
        return this.getConfig(ENCODERS);
    }

    @Override
    public V1CamelNettyBindingModel setEncoders(String encoders) {
        return (V1CamelNettyBindingModel)this.setConfig(ENCODERS, encoders);
    }

    @Override
    public String getDecoders() {
        return this.getConfig(DECODERS);
    }

    @Override
    public V1CamelNettyBindingModel setDecoders(String decoders) {
        return (V1CamelNettyBindingModel)this.setConfig(DECODERS, decoders);
    }

    @Override
    public Boolean isAllowDefaultCodec() {
        return this.getBooleanConfig(ALLOW_DEFAULT_CODEC);
    }

    @Override
    public V1CamelNettyBindingModel setAllowDefaultCodec(Boolean allowDefaultCodec) {
        return (V1CamelNettyBindingModel)this.setConfig(ALLOW_DEFAULT_CODEC, allowDefaultCodec);
    }

    @Override
    public Integer getWorkerCount() {
        return this.getIntegerConfig(WORKER_COUNT);
    }

    @Override
    public V1CamelNettyBindingModel setWorkerCount(Integer workerCount) {
        return (V1CamelNettyBindingModel)this.setConfig(WORKER_COUNT, workerCount);
    }

    @Override
    public Boolean isSync() {
        return this.getBooleanConfig(SYNC);
    }

    @Override
    public V1CamelNettyBindingModel setSync(Boolean sync) {
        return (V1CamelNettyBindingModel)this.setConfig(SYNC, sync);
    }

    @Override
    public Boolean isDisconnect() {
        return this.getBooleanConfig(DISCONNECT);
    }

    @Override
    public V1CamelNettyBindingModel setDisconnect(Boolean disconnect) {
        return (V1CamelNettyBindingModel)this.setConfig(DISCONNECT, disconnect);
    }

    protected abstract String getProtocol();

    public URI getComponentURI() {
        Configuration modelConfiguration = this.getModelConfiguration();
        List children = modelConfiguration.getChildren();
        String baseUri = "netty:" + this.getProtocol() + "://" + this.getHost() + ":" + this.getPort();
        QueryString queryStr = new QueryString();
        this.traverseConfiguration(children, queryStr, new String[]{HOST, PORT});
        return URI.create(baseUri + queryStr.toString());
    }
}

