/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.netty.model.v1;

import java.net.URI;
import java.util.List;
import org.switchyard.component.camel.common.QueryString;
import org.switchyard.component.camel.common.model.v1.V1BaseCamelBindingModel;
import org.switchyard.component.camel.netty.model.CamelNettyBindingModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;

public abstract class V1CamelNettyBindingModel
extends V1BaseCamelBindingModel
implements CamelNettyBindingModel {
    public static final String NETTY = "netty";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String RECEIVE_BUFFER_SIZE = "receiveBufferSize";
    private static final String SEND_BUFFER_SIZE = "sendBufferSize";
    private static final String SSL = "ssl";
    private static final String SSL_HANDLER = "sslHandler";
    private static final String PASSPHRASE = "passphrase";
    private static final String SECURITY_PROVIDER = "securityProvider";
    private static final String KEY_STORE_FORMAT = "keyStoreFormat";
    private static final String KEY_STORE_FILE = "keyStoreFile";
    private static final String TRUST_STORE_FILE = "trustStoreFile";
    private static final String SSL_CONTEXT_PARAMETERS_REF = "sslContextParametersRef";
    private static final String REUSE_ADDRESS = "reuseAddress";
    private static final String ENCODERS = "encoders";
    private static final String DECODERS = "decoders";
    private static final String ALLOW_DEFAULT_CODEC = "allowDefaultCodec";
    private static final String WORKER_COUNT = "workerCount";
    private static final String SYNC = "sync";
    private static final String DISCONNECT = "disconnect";

    protected V1CamelNettyBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    protected V1CamelNettyBindingModel(String name, String namespace) {
        super(name, namespace);
        this.setModelChildrenOrder(new String[]{HOST, PORT, RECEIVE_BUFFER_SIZE, SEND_BUFFER_SIZE, SSL, SSL_HANDLER, PASSPHRASE, SECURITY_PROVIDER, KEY_STORE_FORMAT, KEY_STORE_FILE, TRUST_STORE_FILE, SSL_CONTEXT_PARAMETERS_REF, REUSE_ADDRESS, ENCODERS, DECODERS, ALLOW_DEFAULT_CODEC, WORKER_COUNT, SYNC, DISCONNECT});
    }

    @Override
    public String getHost() {
        return this.getConfig(HOST);
    }

    @Override
    public V1CamelNettyBindingModel setHost(String host) {
        return (V1CamelNettyBindingModel)this.setConfig(HOST, host);
    }

    @Override
    public Integer getPort() {
        return this.getIntegerConfig(PORT);
    }

    @Override
    public V1CamelNettyBindingModel setPort(int port) {
        return (V1CamelNettyBindingModel)this.setConfig(PORT, port);
    }

    @Override
    public Long getReceiveBufferSize() {
        return this.getLongConfig(RECEIVE_BUFFER_SIZE);
    }

    @Override
    public V1CamelNettyBindingModel setReceiveBufferSize(Long receiveBufferSize) {
        return (V1CamelNettyBindingModel)this.setConfig(RECEIVE_BUFFER_SIZE, receiveBufferSize);
    }

    @Override
    public Long getSendBufferSize() {
        return this.getLongConfig(SEND_BUFFER_SIZE);
    }

    @Override
    public V1CamelNettyBindingModel setSendBufferSize(Long sendBufferSize) {
        return (V1CamelNettyBindingModel)this.setConfig(SEND_BUFFER_SIZE, sendBufferSize);
    }

    @Override
    public Boolean isSsl() {
        return this.getBooleanConfig(SSL);
    }

    @Override
    public V1CamelNettyBindingModel setSsl(Boolean ssl) {
        return (V1CamelNettyBindingModel)this.setConfig(SSL, ssl);
    }

    @Override
    public String getSslHandler() {
        return this.getConfig(SSL_HANDLER);
    }

    @Override
    public V1CamelNettyBindingModel setSslHandler(String sslHandler) {
        return (V1CamelNettyBindingModel)this.setConfig(SSL_HANDLER, sslHandler);
    }

    @Override
    public String getPassphrase() {
        return this.getConfig(PASSPHRASE);
    }

    @Override
    public V1CamelNettyBindingModel setPassphrase(String passphrase) {
        return (V1CamelNettyBindingModel)this.setConfig(PASSPHRASE, passphrase);
    }

    @Override
    public String getSecurityProvider() {
        return this.getConfig(SECURITY_PROVIDER);
    }

    @Override
    public V1CamelNettyBindingModel setSecurityProvider(String securityProvider) {
        return (V1CamelNettyBindingModel)this.setConfig(SECURITY_PROVIDER, securityProvider);
    }

    @Override
    public String getKeyStoreFormat() {
        return this.getConfig(KEY_STORE_FORMAT);
    }

    @Override
    public V1CamelNettyBindingModel setKeyStoreFormat(String keyStoreFormat) {
        return (V1CamelNettyBindingModel)this.setConfig(KEY_STORE_FORMAT, keyStoreFormat);
    }

    @Override
    public String getKeyStoreFile() {
        return this.getConfig(KEY_STORE_FILE);
    }

    @Override
    public V1CamelNettyBindingModel setKeyStoreFile(String keyStoreFile) {
        return (V1CamelNettyBindingModel)this.setConfig(KEY_STORE_FILE, keyStoreFile);
    }

    @Override
    public String getTrustStoreFile() {
        return this.getConfig(TRUST_STORE_FILE);
    }

    @Override
    public V1CamelNettyBindingModel setTrustStoreFile(String trustStoreFile) {
        return (V1CamelNettyBindingModel)this.setConfig(TRUST_STORE_FILE, trustStoreFile);
    }

    @Override
    public String getSslContextParametersRef() {
        return this.getConfig(SSL_CONTEXT_PARAMETERS_REF);
    }

    @Override
    public V1CamelNettyBindingModel setSslContextParametersRef(String sslContextParametersRef) {
        return (V1CamelNettyBindingModel)this.setConfig(SSL_CONTEXT_PARAMETERS_REF, sslContextParametersRef);
    }

    @Override
    public Boolean isReuseAddress() {
        return this.getBooleanConfig(REUSE_ADDRESS);
    }

    @Override
    public V1CamelNettyBindingModel setReuseAddress(Boolean reuseAddress) {
        return (V1CamelNettyBindingModel)this.setConfig(REUSE_ADDRESS, reuseAddress);
    }

    @Override
    public String getEncoders() {
        return this.getConfig(ENCODERS);
    }

    @Override
    public V1CamelNettyBindingModel setEncoders(String encoders) {
        return (V1CamelNettyBindingModel)this.setConfig(ENCODERS, encoders);
    }

    @Override
    public String getDecoders() {
        return this.getConfig(DECODERS);
    }

    @Override
    public V1CamelNettyBindingModel setDecoders(String decoders) {
        return (V1CamelNettyBindingModel)this.setConfig(DECODERS, decoders);
    }

    @Override
    public Boolean isAllowDefaultCodec() {
        return this.getBooleanConfig(ALLOW_DEFAULT_CODEC);
    }

    @Override
    public V1CamelNettyBindingModel setAllowDefaultCodec(Boolean allowDefaultCodec) {
        return (V1CamelNettyBindingModel)this.setConfig(ALLOW_DEFAULT_CODEC, allowDefaultCodec);
    }

    @Override
    public Integer getWorkerCount() {
        return this.getIntegerConfig(WORKER_COUNT);
    }

    @Override
    public V1CamelNettyBindingModel setWorkerCount(Integer workerCount) {
        return (V1CamelNettyBindingModel)this.setConfig(WORKER_COUNT, workerCount);
    }

    @Override
    public Boolean isSync() {
        return this.getBooleanConfig(SYNC);
    }

    @Override
    public V1CamelNettyBindingModel setSync(Boolean sync) {
        return (V1CamelNettyBindingModel)this.setConfig(SYNC, sync);
    }

    @Override
    public Boolean isDisconnect() {
        return this.getBooleanConfig(DISCONNECT);
    }

    @Override
    public V1CamelNettyBindingModel setDisconnect(Boolean disconnect) {
        return (V1CamelNettyBindingModel)this.setConfig(DISCONNECT, disconnect);
    }

    protected abstract String getProtocol();

    public URI getComponentURI() {
        Configuration modelConfiguration = this.getModelConfiguration();
        List children = modelConfiguration.getChildren();
        String baseUri = "netty:" + this.getProtocol() + "://" + this.getHost() + ":" + this.getPort();
        QueryString queryStr = new QueryString();
        this.traverseConfiguration(children, queryStr, new String[]{HOST, PORT});
        return URI.create(baseUri + queryStr.toString());
    }
}

