/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.quartz.model.v1;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.switchyard.component.camel.common.QueryString;
import org.switchyard.component.camel.common.model.v1.V1BaseCamelBindingModel;
import org.switchyard.component.camel.quartz.model.CamelQuartzBindingModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;

public class V1CamelQuartzBindingModel
extends V1BaseCamelBindingModel
implements CamelQuartzBindingModel {
    private static final String NAME = "name";
    private static final String CRON = "cron";
    private static final String STATEFUL = "stateful";
    private static final String START_TIME = "trigger.startTime";
    private static final String END_TIME = "trigger.endTime";
    private static final String TIMEZONE = "trigger.timeZone";
    private static final String DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss";

    public V1CamelQuartzBindingModel(String namespace) {
        super("quartz", namespace);
        this.setModelChildrenOrder(new String[]{NAME, CRON, STATEFUL, START_TIME, END_TIME, TIMEZONE});
    }

    public V1CamelQuartzBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    @Override
    public String getTimerName() {
        return this.getConfig(NAME);
    }

    @Override
    public V1CamelQuartzBindingModel setTimerName(String name) {
        return (V1CamelQuartzBindingModel)this.setConfig(NAME, name);
    }

    @Override
    public String getCron() {
        return this.getConfig(CRON);
    }

    @Override
    public V1CamelQuartzBindingModel setCron(String cron) {
        return (V1CamelQuartzBindingModel)this.setConfig(CRON, cron);
    }

    @Override
    public Boolean isStateful() {
        return this.getBooleanConfig(STATEFUL);
    }

    @Override
    public V1CamelQuartzBindingModel setStateful(Boolean stateful) {
        return (V1CamelQuartzBindingModel)this.setConfig(STATEFUL, stateful);
    }

    @Override
    public Date getStartTime() {
        SimpleDateFormat startTimeFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
        return this.getDateConfig(START_TIME, startTimeFormat);
    }

    @Override
    public V1CamelQuartzBindingModel setStartTime(Date startTime) {
        SimpleDateFormat startTimeForamt = new SimpleDateFormat(DATE_FORMAT_STRING);
        return (V1CamelQuartzBindingModel)this.setConfig(START_TIME, startTimeForamt.format(startTime));
    }

    @Override
    public Date getEndTime() {
        SimpleDateFormat endTimeFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
        return this.getDateConfig(END_TIME, endTimeFormat);
    }

    @Override
    public V1CamelQuartzBindingModel setEndTime(Date endTime) {
        SimpleDateFormat endTimeFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
        return (V1CamelQuartzBindingModel)this.setConfig(END_TIME, endTimeFormat.format(endTime));
    }

    @Override
    public String getTimeZone() {
        return this.getConfig(TIMEZONE);
    }

    @Override
    public V1CamelQuartzBindingModel setTimeZone(String timeZone) {
        return (V1CamelQuartzBindingModel)this.setConfig(TIMEZONE, timeZone);
    }

    public URI getComponentURI() {
        Configuration modelConfiguration = this.getModelConfiguration();
        List children = modelConfiguration.getChildren();
        String baseUri = "quartz://" + this.getTimerName();
        QueryString queryStr = new QueryString();
        this.traverseConfiguration(children, queryStr, new String[]{NAME});
        return URI.create(UnsafeUriCharactersEncoder.encode((String)(baseUri + queryStr.toString())));
    }
}

