/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.sap.model.v2;

import java.net.URI;
import java.util.List;
import org.switchyard.component.camel.common.QueryString;
import org.switchyard.component.camel.common.model.v1.V1BaseCamelBindingModel;
import org.switchyard.component.camel.sap.model.CamelSapBindingModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;

public class V2CamelSapBindingModel
extends V1BaseCamelBindingModel
implements CamelSapBindingModel {
    public static final String SAP = "sap";
    private static final String SERVER = "server";
    private static final String DESTINATION = "destination";
    private static final String RFC_NAME = "rfcName";
    private static final String TRANSACTED = "transacted";

    public V2CamelSapBindingModel(String namespace) {
        super(SAP, namespace);
        this.setModelChildrenOrder(new String[]{SERVER, DESTINATION, RFC_NAME, TRANSACTED});
    }

    public V2CamelSapBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    @Override
    public String getServer() {
        return this.getConfig(SERVER);
    }

    @Override
    public V2CamelSapBindingModel setServer(String server) {
        this.setConfig(SERVER, server);
        return this;
    }

    @Override
    public String getDestination() {
        return this.getConfig(DESTINATION);
    }

    @Override
    public V2CamelSapBindingModel setDestination(String destination) {
        this.setConfig(DESTINATION, destination);
        return this;
    }

    @Override
    public String getRfcName() {
        return this.getConfig(RFC_NAME);
    }

    @Override
    public V2CamelSapBindingModel setRfcName(String rfcName) {
        this.setConfig(RFC_NAME, rfcName);
        return this;
    }

    @Override
    public Boolean isTransacted() {
        return this.getBooleanConfig(TRANSACTED);
    }

    @Override
    public V2CamelSapBindingModel setTransacted(Boolean transacted) {
        this.setConfig(TRANSACTED, transacted);
        return this;
    }

    public URI getComponentURI() {
        Configuration modelConfiguration = this.getModelConfiguration();
        List children = modelConfiguration.getChildren();
        StringBuilder uriBuf = new StringBuilder(SAP);
        if (this.isReferenceBinding()) {
            uriBuf.append(":destination:").append(this.getDestination());
        } else {
            uriBuf.append(":server:").append(this.getServer());
        }
        uriBuf.append(":").append(this.getRfcName());
        QueryString queryString = new QueryString();
        this.traverseConfiguration(children, queryString, new String[]{SERVER, DESTINATION, RFC_NAME});
        uriBuf.append(queryString.toString());
        return URI.create(uriBuf.toString());
    }
}

