/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.sql.deploy;

import javax.xml.namespace.QName;
import org.apache.camel.Processor;
import org.apache.camel.model.RouteDefinition;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.camel.common.SwitchYardRouteDefinition;
import org.switchyard.component.camel.common.handler.InboundHandler;
import org.switchyard.component.camel.common.handler.OperationSelectorProcessor;
import org.switchyard.component.camel.common.model.CamelBindingModel;
import org.switchyard.component.camel.sql.model.CamelSqlBindingModel;
import org.switchyard.exception.SwitchYardException;

public class CamelSqlInboundHandler
extends InboundHandler<CamelSqlBindingModel> {
    public CamelSqlInboundHandler(CamelSqlBindingModel camelBindingModel, SwitchYardCamelContext camelContext, QName serviceName) {
        super((CamelBindingModel)camelBindingModel, camelContext, serviceName);
    }

    protected RouteDefinition createRouteDefinition() {
        CamelSqlBindingModel bindingModel = (CamelSqlBindingModel)this.getBindingModel();
        QName serviceName = this.getServiceName();
        String period = bindingModel.getPeriod();
        if (bindingModel.isServiceBinding()) {
            if (Strings.trimToNull((String)period) == null) {
                throw new SwitchYardException("Period attribute is mandatory for SQL service bindings");
            }
            SwitchYardRouteDefinition definition = new SwitchYardRouteDefinition(serviceName);
            ((RouteDefinition)definition.routeId(this.getRouteId()).from(((CamelSqlBindingModel)this.getBindingModel()).getTimerURI(this.getRouteId()).toString()).to(((CamelSqlBindingModel)this.getBindingModel()).getComponentURI().toString())).process((Processor)new OperationSelectorProcessor(serviceName, (CamelBindingModel)bindingModel));
            return this.addTransactionPolicy(definition);
        }
        return super.createRouteDefinition();
    }
}

