/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.sql.deploy;

import javax.xml.namespace.QName;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.switchyard.ServiceDomain;
import org.switchyard.SwitchYardException;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.camel.common.handler.InboundHandler;
import org.switchyard.component.camel.common.handler.MessageComposerProcessor;
import org.switchyard.component.camel.common.handler.OperationSelectorProcessor;
import org.switchyard.component.camel.common.model.CamelBindingModel;
import org.switchyard.component.camel.sql.model.CamelSqlBindingModel;

public class CamelSqlInboundHandler
extends InboundHandler<CamelSqlBindingModel> {
    public CamelSqlInboundHandler(CamelSqlBindingModel camelBindingModel, SwitchYardCamelContext camelContext, QName serviceName, ServiceDomain domain) {
        super((CamelBindingModel)camelBindingModel, camelContext, serviceName, domain);
    }

    protected RouteDefinition createRouteDefinition() {
        CamelSqlBindingModel bindingModel = (CamelSqlBindingModel)this.getBindingModel();
        QName serviceName = this.getServiceName();
        String period = bindingModel.getPeriod();
        if (bindingModel.isServiceBinding()) {
            if (Strings.trimToNull((String)period) == null) {
                throw new SwitchYardException("Period attribute is mandatory for SQL service bindings");
            }
            RouteDefinition definition = new RouteDefinition();
            ((RouteDefinition)((ProcessorDefinition)((ProcessorDefinition)((RouteDefinition)definition.routeId(this.getRouteId()).from(((CamelSqlBindingModel)this.getBindingModel()).getTimerURI(this.getRouteId()).toString()).to(((CamelSqlBindingModel)this.getBindingModel()).getComponentURI().toString())).setProperty("org.switchyard.exchangeGatewayName").simple(((CamelSqlBindingModel)this.getBindingModel()).getName(), String.class)).setProperty("org.switchyard.component.camel.namespace").constant((Object)serviceName.getNamespaceURI())).process((Processor)new MessageComposerProcessor(this.getBindingModel()))).process((Processor)new OperationSelectorProcessor(serviceName, (CamelBindingModel)bindingModel));
            return this.addTransactionPolicy(definition);
        }
        return super.createRouteDefinition();
    }
}

