/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.sql.model.v1;

import java.net.URI;
import java.util.List;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.switchyard.component.camel.common.QueryString;
import org.switchyard.component.camel.common.model.v1.V1BaseCamelBindingModel;
import org.switchyard.component.camel.sql.model.CamelSqlBindingModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;

public class V1CamelSqlBindingModel
extends V1BaseCamelBindingModel
implements CamelSqlBindingModel {
    public static final String SQL = "sql";
    private static final String QUERY = "query";
    private static final String DATA_SOURCE_REF = "dataSourceRef";
    private static final String BATCH = "batch";
    private static final String PLACEHOLDER = "placeholder";
    private static final String PERIOD = "period";
    private static final String INITIAL_DELAY = "initialDelay";

    public V1CamelSqlBindingModel(String namespace) {
        super(SQL, namespace);
        this.setModelChildrenOrder(new String[]{QUERY, DATA_SOURCE_REF, BATCH, PLACEHOLDER});
    }

    public V1CamelSqlBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    @Override
    public String getQuery() {
        return this.getConfig(QUERY);
    }

    @Override
    public V1CamelSqlBindingModel setQuery(String query) {
        return (V1CamelSqlBindingModel)this.setConfig(QUERY, query);
    }

    @Override
    public String getDataSourceRef() {
        return this.getConfig(DATA_SOURCE_REF);
    }

    @Override
    public V1CamelSqlBindingModel setDataSourceRef(String dataSourceRef) {
        return (V1CamelSqlBindingModel)this.setConfig(DATA_SOURCE_REF, dataSourceRef);
    }

    @Override
    public Boolean isBatch() {
        return this.getBooleanConfig(BATCH);
    }

    @Override
    public V1CamelSqlBindingModel setBatch(Boolean batch) {
        return (V1CamelSqlBindingModel)this.setConfig(BATCH, batch);
    }

    @Override
    public String getPlaceholder() {
        return this.getConfig(PLACEHOLDER);
    }

    @Override
    public V1CamelSqlBindingModel setPlaceholder(String placeholder) {
        return (V1CamelSqlBindingModel)this.setConfig(PLACEHOLDER, placeholder);
    }

    @Override
    public String getPeriod() {
        return this.getModelAttribute(PERIOD);
    }

    @Override
    public V1CamelSqlBindingModel setPeriod(String schedule) {
        this.setModelAttribute(PERIOD, schedule);
        return this;
    }

    @Override
    public V1CamelSqlBindingModel setInitialDelay(Long initialDelay) {
        this.setModelAttribute(INITIAL_DELAY, Long.toString(initialDelay));
        return this;
    }

    @Override
    public Long getInitialDelay() {
        String value = this.getModelAttribute(INITIAL_DELAY);
        return value == null ? null : Long.valueOf(value);
    }

    @Override
    public String getTimerURI(String name) {
        QueryString queryStr = new QueryString();
        queryStr.add(PERIOD, (Object)this.getPeriod());
        queryStr.add("delay", (Object)this.getInitialDelay());
        return UnsafeUriCharactersEncoder.encode((String)("timer://" + name + queryStr));
    }

    public URI getComponentURI() {
        Configuration modelConfiguration = this.getModelConfiguration();
        List children = modelConfiguration.getChildren();
        String baseUri = "sql://" + this.getQuery();
        QueryString queryStr = new QueryString();
        this.traverseConfiguration(children, queryStr, new String[]{QUERY});
        return URI.create(UnsafeUriCharactersEncoder.encode((String)(baseUri + queryStr.toString())));
    }
}

