/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.camel.impl.DefaultMessage;
import org.switchyard.Exchange;
import org.switchyard.ExchangePhase;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.common.camel.ContextPropertyUtil;
import org.switchyard.common.camel.HandlerDataSource;
import org.switchyard.common.camel.SwitchYardMessage;
import org.switchyard.label.BehaviorLabel;

public final class ExchangeMapper {
    private ExchangeMapper() {
    }

    public static Message mapCamelToSwitchYard(org.apache.camel.Exchange camelExchange, Exchange syExchange, ExchangePhase phase) {
        Message message = syExchange.createMessage();
        org.apache.camel.Message camelMessage = phase.equals((Object)ExchangePhase.OUT) && camelExchange.hasOut() ? camelExchange.getOut() : camelExchange.getIn();
        message.setContent(camelMessage.getBody());
        for (String property : camelExchange.getProperties().keySet()) {
            if (ContextPropertyUtil.isReservedProperty((String)property, (Scope)Scope.EXCHANGE) || "org.switchyard.component.camel.implementation".equals(property)) continue;
            message.getContext().setProperty(property, camelExchange.getProperty(property), Scope.EXCHANGE);
        }
        for (String header : camelMessage.getHeaders().keySet()) {
            if (ContextPropertyUtil.isReservedProperty((String)header, (Scope)Scope.MESSAGE)) continue;
            message.getContext().setProperty(header, camelMessage.getHeader(header), Scope.MESSAGE);
        }
        for (String attachmentName : camelMessage.getAttachmentNames()) {
            message.addAttachment(attachmentName, (DataSource)new HandlerDataSource(camelMessage.getAttachment(attachmentName)));
        }
        return message;
    }

    public static DefaultMessage mapSwitchYardToCamel(Exchange syExchange, org.apache.camel.Exchange camelExchange) {
        SwitchYardMessage camelMessage = new SwitchYardMessage();
        camelMessage.setBody(syExchange.getMessage().getContent());
        for (Property property : syExchange.getContext().getProperties()) {
            if (property.hasLabel(BehaviorLabel.TRANSIENT.label()) || ContextPropertyUtil.isReservedProperty((String)property.getName(), (Scope)property.getScope())) continue;
            if (Scope.EXCHANGE.equals((Object)property.getScope())) {
                camelExchange.setProperty(property.getName(), property.getValue());
                continue;
            }
            camelMessage.setHeader(property.getName(), property.getValue());
        }
        for (String attachmentName : syExchange.getMessage().getAttachmentMap().keySet()) {
            camelMessage.addAttachment(attachmentName, new DataHandler(syExchange.getMessage().getAttachment(attachmentName)));
        }
        return camelMessage;
    }
}

