/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.config.test.v1;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import org.apache.camel.Endpoint;
import org.apache.camel.util.URISupport;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Test;
import org.switchyard.component.camel.common.model.CamelBindingModel;
import org.switchyard.component.camel.common.model.v1.V1BaseCamelBindingModel;
import org.switchyard.component.camel.config.test.v1.V1BaseCamelModelTest;

public abstract class V1BaseCamelServiceBindingModelTest<T extends V1BaseCamelBindingModel, E extends Endpoint>
extends V1BaseCamelModelTest<T> {
    private String _fileName;
    private boolean _valid;
    private Class<E> _endpointType;
    private boolean _skipCamelEndpointTesting;

    protected V1BaseCamelServiceBindingModelTest(Class<E> endpointType, String fileName, boolean valid) {
        this._endpointType = endpointType;
        this._fileName = fileName;
        this._valid = valid;
    }

    protected V1BaseCamelServiceBindingModelTest(Class<E> endpointType, String fileName) {
        this(endpointType, fileName, true);
    }

    public void setSkipCamelEndpointTesting(boolean skip) {
        this._skipCamelEndpointTesting = skip;
    }

    @Test
    public void testFileIsValid() throws Exception {
        this.validModel(this.getFirstBinding());
    }

    @Test
    public void testModelIsValid() throws Exception {
        this.validModel(this.createTestModel());
    }

    @Test
    public void testModelAssertionsFromFile() throws Exception {
        this.createModelAssertions(this.getFirstBinding());
    }

    @Test
    public void testModelAssertionsFromModel() {
        this.createModelAssertions(this.createTestModel());
    }

    @Test
    public void testModelChildrenOrder() {
        this.validModel((V1BaseCamelBindingModel)this.createTestModel().orderModelChildren());
    }

    @Test
    public void testSimilarityBetweenFileAndModel() throws Exception {
        String refXml = this.getFirstBinding().toString();
        String newXml = this.createTestModel().toString();
        XMLUnit.setIgnoreWhitespace((boolean)true);
        Diff diff = XMLUnit.compareXML((String)refXml, (String)newXml);
        if (!diff.similar()) {
            System.out.println("Expected\n" + refXml);
            System.out.println("Generated\n" + newXml);
        }
        junit.framework.Assert.assertTrue((String)diff.toString(), (boolean)diff.similar());
    }

    @Test
    public void testCamelEndpointUriFromModel() throws Exception {
        this.verifyCamelEndpointUri(this.createTestModel());
    }

    @Test
    public void testCamelEndpointUriFromFile() throws Exception {
        this.verifyCamelEndpointUri(this.getFirstBinding());
    }

    @Test
    public void verifyModelUri() throws Exception {
        String componentURI = this.createTestModel().getComponentURI().toString();
        this.assertUriEquals(this.createEndpointUri(), URISupport.normalizeUri((String)componentURI));
    }

    protected void validModel(T model) {
        if (this._valid) {
            model.assertModelValid();
        } else {
            try {
                model.assertModelValid();
                Assert.fail((String)"Expected invalid model, but validation framework did not report any problems");
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
    }

    protected void verifyCamelEndpointUri(T model) {
        if (this._skipCamelEndpointTesting) {
            return;
        }
        this.assertUriEquals(this.createEndpointUri(), this.getEndpoint((CamelBindingModel)model, this._endpointType).getEndpointUri());
    }

    protected void assertUriEquals(String expected, String given) {
        try {
            Assert.assertEquals((Object)URISupport.normalizeUri((String)expected), (Object)given);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Unsuported encoding", e);
        }
        catch (URISyntaxException e) {
            throw new Error("Uri syntax is invalid", e);
        }
    }

    protected T getFirstBinding() throws Exception {
        return (T)((V1BaseCamelBindingModel)this.getFirstCamelBinding(this._fileName));
    }

    protected abstract String createEndpointUri();

    protected abstract void createModelAssertions(T var1);

    protected abstract T createTestModel();

    protected Class<E> getEndpointType() {
        return this._endpointType;
    }

    protected String getFileName() {
        return this._fileName;
    }
}

