/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.config.test.v1;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.BeforeClass;
import org.switchyard.common.type.Classes;
import org.switchyard.component.camel.common.model.AdditionalUriParametersModel;
import org.switchyard.component.camel.common.model.CamelBindingModel;
import org.switchyard.component.camel.common.model.v1.V1AdditionalUriParametersModel;
import org.switchyard.component.camel.common.model.v1.V1ParameterModel;
import org.switchyard.config.model.ModelPuller;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;

public abstract class V1BaseCamelModelTest<T extends CamelBindingModel> {
    private static CamelContext context;

    @BeforeClass
    public static void setUpClass() {
        context = new DefaultCamelContext();
    }

    protected T getFirstCamelBinding(String config) throws Exception {
        InputStream in = Classes.getResourceAsStream((String)config, this.getClass());
        SwitchYardModel model = (SwitchYardModel)new ModelPuller().pull(in);
        List services = model.getComposite().getServices();
        CompositeServiceModel compositeServiceModel = (CompositeServiceModel)services.get(0);
        List bindings = compositeServiceModel.getBindings();
        return (T)((CamelBindingModel)bindings.get(0));
    }

    protected T getFirstCamelReferenceBinding(String config) throws Exception {
        InputStream in = Classes.getResourceAsStream((String)config, this.getClass());
        SwitchYardModel model = (SwitchYardModel)new ModelPuller().pull(in);
        List services = model.getComposite().getReferences();
        CompositeReferenceModel compositeServiceModel = (CompositeReferenceModel)services.get(0);
        List bindings = compositeServiceModel.getBindings();
        return (T)((CamelBindingModel)bindings.get(0));
    }

    protected T getFirstCamelModelBinding(String config) throws Exception {
        InputStream in = Classes.getResourceAsStream((String)config, this.getClass());
        CamelBindingModel model = (CamelBindingModel)new ModelPuller().pull(in);
        return (T)model;
    }

    protected <E extends Endpoint> E getEndpoint(CamelBindingModel model, Class<E> enpointType) {
        String configUri = model.getComponentURI().toString();
        return (E)context.getEndpoint(configUri, enpointType);
    }

    protected static AdditionalUriParametersModel createAdditionalUriParametersModel(String namespace, Map<String, String> parameters) {
        V1AdditionalUriParametersModel retVal = new V1AdditionalUriParametersModel(namespace);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            retVal.addParameter(new V1ParameterModel(namespace).setName(entry.getKey()).setValue(entry.getValue()));
        }
        return retVal;
    }
}

