/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel;

import javax.xml.namespace.QName;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerException;
import org.switchyard.ServiceReference;
import org.switchyard.component.camel.deploy.ServiceReferences;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.java.JavaService;

public class CamelResponseHandler
implements ExchangeHandler {
    private final org.apache.camel.Exchange _camelExchange;
    private final ServiceReference _reference;

    public CamelResponseHandler(org.apache.camel.Exchange camelExchange, ServiceReference reference) {
        if (camelExchange == null) {
            throw new SwitchYardException("[camelExchange] argument must not be null");
        }
        if (reference == null) {
            throw new SwitchYardException("[reference] argument must not be null");
        }
        this._camelExchange = camelExchange;
        this._reference = reference;
    }

    public void handleMessage(Exchange switchYardExchange) throws HandlerException {
        Object payload = this.getPayloadFromSwitchYardExchange(switchYardExchange);
        this._camelExchange.getIn().setBody(payload);
    }

    private Object getPayloadFromSwitchYardExchange(Exchange switchYardExchange) {
        QName outputType = ServiceReferences.getOutputTypeForExchange(this._reference, switchYardExchange);
        if (outputType != null) {
            return switchYardExchange.getMessage().getContent(JavaService.toJavaMessageType((QName)outputType));
        }
        return switchYardExchange.getMessage().getContent();
    }

    public void handleFault(Exchange exchange) {
        Object content = exchange.getMessage().getContent();
        if (content instanceof Throwable) {
            this._camelExchange.setException((Throwable)content);
        }
    }
}

