/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFileProducer<T>
extends DefaultProducer {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    protected final GenericFileEndpoint<T> endpoint;
    protected GenericFileOperations<T> operations;

    protected GenericFileProducer(GenericFileEndpoint<T> endpoint, GenericFileOperations<T> operations) {
        super(endpoint);
        this.endpoint = endpoint;
        this.operations = operations;
    }

    public String getFileSeparator() {
        return File.separator;
    }

    public String normalizePath(String name) {
        return FileUtil.normalizePath(name);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Exchange fileExchange = this.endpoint.createExchange(exchange);
        this.endpoint.configureExchange(fileExchange);
        this.processExchange(fileExchange);
        ExchangeHelper.copyResults(exchange, fileExchange);
    }

    public void setOperations(GenericFileOperations<T> operations) {
        this.operations = operations;
    }

    protected void processExchange(Exchange exchange) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Processing " + exchange));
        }
        try {
            String target = this.createFileName(exchange);
            this.preWriteCheck();
            boolean writeAsTempAndRename = ObjectHelper.isNotEmpty(this.endpoint.getTempFileName());
            String tempTarget = null;
            if (writeAsTempAndRename) {
                tempTarget = this.createTempFileName(exchange, target);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Writing using tempNameFile: " + tempTarget));
                }
                if (this.operations.existsFile(target)) {
                    if (this.endpoint.getFileExist() == GenericFileExist.Ignore) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("An existing file already exists: " + target + ". Ignore and do not override it."));
                        }
                        return;
                    }
                    if (this.endpoint.getFileExist() == GenericFileExist.Fail) {
                        throw new GenericFileOperationFailedException("File already exist: " + target + ". Cannot write new file.");
                    }
                    if (this.endpoint.isEagerDeleteTargetFile() && this.endpoint.getFileExist() == GenericFileExist.Override) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Eagerly deleting existing file: " + target));
                        }
                        if (!this.operations.deleteFile(target)) {
                            throw new GenericFileOperationFailedException("Cannot delete file: " + target);
                        }
                    }
                }
                if (this.operations.existsFile(tempTarget)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Deleting existing temp file: " + tempTarget));
                    }
                    if (!this.operations.deleteFile(tempTarget)) {
                        throw new GenericFileOperationFailedException("Cannot delete file: " + tempTarget);
                    }
                }
            }
            this.writeFile(exchange, tempTarget != null ? tempTarget : target);
            if (tempTarget != null) {
                boolean renamed;
                if (!this.endpoint.isEagerDeleteTargetFile() && this.operations.existsFile(target) && this.endpoint.getFileExist() == GenericFileExist.Override) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Deleting existing file: " + target));
                    }
                    if (!this.operations.deleteFile(target)) {
                        throw new GenericFileOperationFailedException("Cannot delete file: " + target);
                    }
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Renaming file: [" + tempTarget + "] to: [" + target + "]"));
                }
                if (!(renamed = this.operations.renameFile(tempTarget, target))) {
                    throw new GenericFileOperationFailedException("Cannot rename file from: " + tempTarget + " to: " + target);
                }
            }
            if (this.endpoint.getDoneFileName() != null) {
                String doneFileName = this.endpoint.createDoneFileName(target);
                ObjectHelper.notEmpty(doneFileName, "doneFileName", this.endpoint);
                DefaultExchange empty = new DefaultExchange(exchange);
                empty.getIn().setBody("");
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Writing done file: [" + doneFileName + "]"));
                }
                if (this.operations.existsFile(doneFileName) && !this.operations.deleteFile(doneFileName)) {
                    throw new GenericFileOperationFailedException("Cannot delete existing done file: " + doneFileName);
                }
                this.writeFile(empty, doneFileName);
            }
            exchange.getIn().setHeader("CamelFileNameProduced", target);
        }
        catch (Exception e) {
            this.handleFailedWrite(exchange, e);
        }
        this.postWriteCheck();
    }

    public void handleFailedWrite(Exchange exchange, Exception exception) throws Exception {
        throw exception;
    }

    public void preWriteCheck() throws Exception {
    }

    public void postWriteCheck() {
    }

    public void writeFile(Exchange exchange, String fileName) throws GenericFileOperationFailedException {
        boolean success;
        if (this.endpoint.isAutoCreate()) {
            String name = FileUtil.normalizePath(fileName);
            File file = new File(name);
            String directory = file.getParent();
            boolean absolute = FileUtil.isAbsolute(file);
            if (directory != null && !this.operations.buildDirectory(directory, absolute) && this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cannot build directory [" + directory + "] (could be because of denied permissions)"));
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("About to write [" + fileName + "] to [" + this.getEndpoint() + "] from exchange [" + exchange + "]"));
        }
        if (!(success = this.operations.storeFile(fileName, exchange))) {
            throw new GenericFileOperationFailedException("Error writing file [" + fileName + "]");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Wrote [" + fileName + "] to [" + this.getEndpoint() + "]"));
        }
    }

    public String createFileName(Exchange exchange) {
        String name = exchange.getIn().getHeader("CamelFileName", String.class);
        Expression expression = this.endpoint.getFileName();
        if (name != null && SimpleLanguage.hasStartToken(name)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("CamelFileName contains a Simple expression: " + name));
            }
            Language language = this.getEndpoint().getCamelContext().resolveLanguage("file");
            expression = language.createExpression(name);
        }
        if (expression != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Filename evaluated as expression: " + expression));
            }
            name = expression.evaluate(exchange, String.class);
        }
        if (name != null && this.endpoint.isFlatten()) {
            int pos = name.lastIndexOf(this.getFileSeparator());
            if (pos == -1) {
                pos = name.lastIndexOf(47);
            }
            if (pos != -1) {
                name = name.substring(pos + 1);
            }
        }
        String endpointPath = this.endpoint.getConfiguration().getDirectory();
        String baseDir = "";
        if (endpointPath.length() > 0) {
            baseDir = endpointPath + (endpointPath.endsWith(this.getFileSeparator()) ? "" : this.getFileSeparator());
        }
        String answer = name != null ? baseDir + name : baseDir + this.endpoint.getGeneratedFileName(exchange.getIn());
        if (this.endpoint.getConfiguration().needToNormalize()) {
            answer = this.normalizePath(answer);
        }
        return answer;
    }

    public String createTempFileName(Exchange exchange, String fileName) {
        String tempName;
        fileName = this.normalizePath(fileName);
        if (exchange.getIn().getHeader("CamelFileName") == null) {
            exchange.getIn().setHeader("CamelFileName", FileUtil.stripPath(fileName));
            tempName = this.endpoint.getTempFileName().evaluate(exchange, String.class);
            exchange.getIn().removeHeader("CamelFileName");
        } else {
            tempName = this.endpoint.getTempFileName().evaluate(exchange, String.class);
        }
        int path = fileName.lastIndexOf(this.getFileSeparator());
        if (path == -1) {
            return tempName;
        }
        StringBuilder sb = new StringBuilder(fileName.substring(0, path + 1));
        sb.append(tempName);
        return sb.toString();
    }
}

