/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.loadbalancer;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.LoadBalancerDefinition;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.WeightedLoadBalancer;
import org.apache.camel.processor.loadbalancer.WeightedRandomLoadBalancer;
import org.apache.camel.processor.loadbalancer.WeightedRoundRobinLoadBalancer;
import org.apache.camel.spi.RouteContext;

@XmlRootElement(name="weighted")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WeightedLoadBalancerDefinition
extends LoadBalancerDefinition {
    @XmlAttribute(name="roundRobin", required=false)
    private Boolean roundRobin = Boolean.FALSE;
    @XmlAttribute(name="distributionRatio", required=true)
    private String distributionRatio;
    @XmlAttribute(name="distributionRatioDelimiter", required=false)
    private String distributionRatioDelimiter;

    protected LoadBalancer createLoadBalancer(RouteContext routeContext) {
        WeightedLoadBalancer loadBalancer = null;
        ArrayList<Integer> distributionRatioList = new ArrayList<Integer>();
        try {
            String[] ratios;
            if (this.distributionRatioDelimiter == null) {
                this.distributionRatioDelimiter = ",";
            }
            for (String ratio : ratios = this.distributionRatio.split(this.distributionRatioDelimiter)) {
                distributionRatioList.add(new Integer(ratio.trim()));
            }
            loadBalancer = !this.roundRobin.booleanValue() ? new WeightedRandomLoadBalancer(distributionRatioList) : new WeightedRoundRobinLoadBalancer(distributionRatioList);
        }
        catch (Exception e) {
            // empty catch block
        }
        return loadBalancer;
    }

    public Boolean isRoundRobin() {
        return this.roundRobin;
    }

    public void setRoundRobin(Boolean roundRobin) {
        this.roundRobin = roundRobin;
    }

    public String getDistributionRatio() {
        return this.distributionRatio;
    }

    public void setDistributionRatioList(String distributionRatio) {
        this.distributionRatio = distributionRatio;
    }

    public String toString() {
        if (!this.roundRobin.booleanValue()) {
            return "WeightedRandomLoadBalancer[" + this.distributionRatio + "]";
        }
        return "WeightedRoundRobinLoadBalancer[" + this.distributionRatio + "]";
    }
}

