/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.converter.IOConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertBodyProcessor
implements Processor {
    private final Class<?> type;
    private final String charset;

    public ConvertBodyProcessor(Class<?> type) {
        this.type = type;
        this.charset = null;
    }

    public ConvertBodyProcessor(Class<?> type, String charset) {
        this.type = type;
        this.charset = charset;
    }

    public String toString() {
        return "convertBodyTo[" + this.type.getCanonicalName() + "]";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        if (this.charset != null) {
            exchange.setProperty("CamelCharsetName", IOConverter.normalizeCharset(this.charset));
        }
        if (in.getBody() != null) {
            Object value = in.getMandatoryBody(this.type);
            if (exchange.getPattern().isOutCapable()) {
                Message out = exchange.getOut();
                out.copyFrom(in);
                out.setBody(value);
            } else {
                in.setBody(value);
            }
        }
    }

    public Class<?> getType() {
        return this.type;
    }
}

