/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.processor.Traceable;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pipeline
extends MulticastProcessor
implements AsyncProcessor,
Traceable {
    private static final transient Log LOG = LogFactory.getLog(Pipeline.class);

    public Pipeline(CamelContext camelContext, Collection<Processor> processors) {
        super(camelContext, processors);
    }

    public static Processor newInstance(CamelContext camelContext, List<Processor> processors) {
        if (processors.isEmpty()) {
            return null;
        }
        if (processors.size() == 1) {
            return processors.get(0);
        }
        return new Pipeline(camelContext, processors);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Iterator<Processor> processors = this.getProcessors().iterator();
        Exchange nextExchange = exchange;
        boolean first = true;
        while (this.continueRouting(processors, nextExchange)) {
            if (first) {
                first = false;
            } else {
                nextExchange = this.createNextExchange(nextExchange);
            }
            Processor processor = processors.next();
            AsyncProcessor async = AsyncProcessorTypeConverter.convert(processor);
            boolean sync = this.process(exchange, nextExchange, callback, processors, async);
            if (!sync) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Processing exchangeId: " + exchange.getExchangeId() + " is continued being processed asynchronously"));
                }
                return false;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Processing exchangeId: " + exchange.getExchangeId() + " is continued being processed synchronously"));
            }
            if (PipelineHelper.continueProcessing(nextExchange, "so breaking out of pipeline", LOG)) continue;
            break;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Processing complete for exchangeId: " + exchange.getExchangeId() + " >>> " + nextExchange));
        }
        ExchangeHelper.copyResults(exchange, nextExchange);
        callback.done(true);
        return true;
    }

    private boolean process(final Exchange original, final Exchange exchange, final AsyncCallback callback, final Iterator<Processor> processors, AsyncProcessor asyncProcessor) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Processing exchangeId: " + exchange.getExchangeId() + " >>> " + exchange));
        }
        boolean sync = AsyncProcessorHelper.process(asyncProcessor, exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (doneSync) {
                    return;
                }
                Exchange nextExchange = exchange;
                while (Pipeline.this.continueRouting(processors, nextExchange)) {
                    AsyncProcessor processor = AsyncProcessorTypeConverter.convert((Processor)processors.next());
                    if (!PipelineHelper.continueProcessing(nextExchange, "so breaking out of pipeline", LOG)) break;
                    doneSync = Pipeline.this.process(original, nextExchange = Pipeline.this.createNextExchange(nextExchange), callback, processors, processor);
                    if (doneSync) continue;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Processing exchangeId: " + exchange.getExchangeId() + " is continued being processed asynchronously"));
                    }
                    return;
                }
                ExchangeHelper.copyResults(original, nextExchange);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Processing complete for exchangeId: " + original.getExchangeId() + " >>> " + original));
                }
                callback.done(false);
            }
        });
        return sync;
    }

    protected Exchange createNextExchange(Exchange previousExchange) {
        DefaultExchange answer = new DefaultExchange(previousExchange);
        answer.setExchangeId(previousExchange.getExchangeId());
        answer.getProperties().putAll(previousExchange.getProperties());
        answer.setIn(previousExchange.hasOut() ? previousExchange.getOut().copy() : previousExchange.getIn().copy());
        return answer;
    }

    protected boolean continueRouting(Iterator<Processor> it, Exchange exchange) {
        boolean answer = true;
        Object stop = exchange.getProperty("CamelRouteStop");
        if (stop != null) {
            boolean doStop = exchange.getContext().getTypeConverter().convertTo(Boolean.class, stop);
            if (doStop) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ExchangeId: " + exchange.getExchangeId() + " is marked to stop routing: " + exchange));
                }
                answer = false;
            }
        } else {
            answer = it.hasNext();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ExchangeId: " + exchange.getExchangeId() + " should continue routing: " + answer));
        }
        return answer;
    }

    @Override
    public String toString() {
        return "Pipeline[" + this.getProcessors() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "pipeline";
    }
}

