/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent;

import java.util.Map;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.util.LRUCache;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(value="MemoryIdempotentRepository")
public class MemoryIdempotentRepository
extends ServiceSupport
implements IdempotentRepository<String> {
    private Map<String, Object> cache;
    private int cacheSize;

    public MemoryIdempotentRepository() {
        this.cache = new LRUCache<String, Object>(1000);
    }

    public MemoryIdempotentRepository(Map<String, Object> set) {
        this.cache = set;
    }

    public static IdempotentRepository<String> memoryIdempotentRepository() {
        return new MemoryIdempotentRepository();
    }

    public static IdempotentRepository<String> memoryIdempotentRepository(int cacheSize) {
        return MemoryIdempotentRepository.memoryIdempotentRepository(new LRUCache<String, Object>(cacheSize));
    }

    public static IdempotentRepository<String> memoryIdempotentRepository(Map<String, Object> cache) {
        return new MemoryIdempotentRepository(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String key) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            if (this.cache.containsKey(key)) {
                return false;
            }
            this.cache.put(key, key);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String key) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            return this.cache.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String key) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            return this.cache.remove(key) != null;
        }
    }

    @Override
    public boolean confirm(String key) {
        return true;
    }

    public Map<String, Object> getCache() {
        return this.cache;
    }

    @ManagedAttribute(description="The current cache size")
    public int getCacheSize() {
        return this.cache.size();
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.cacheSize > 0) {
            this.cache = new LRUCache<String, Object>(this.cacheSize);
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.cache.clear();
    }
}

