/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel;

import java.util.List;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.switchyard.common.type.Classes;
import org.switchyard.component.camel.Route;
import org.switchyard.exception.SwitchYardException;

public final class RouteFactory {
    private RouteFactory() {
    }

    public static RouteDefinition createRoute(String className) {
        return RouteFactory.createRoute(Classes.forName((String)className));
    }

    public static RouteDefinition createRoute(Class<?> routeClass) {
        RouteBuilder builder;
        if (!routeClass.isAnnotationPresent(Route.class)) {
            throw new SwitchYardException("@Route definition is missing on class " + routeClass.getName());
        }
        if (!RouteBuilder.class.isAssignableFrom(routeClass)) {
            throw new SwitchYardException("Java DSL class " + routeClass.getName() + " must extend " + RouteBuilder.class.getName());
        }
        RouteDefinition route = null;
        try {
            builder = (RouteBuilder)routeClass.newInstance();
            builder.configure();
        }
        catch (Exception ex) {
            throw new SwitchYardException("Failed to initialize Java DSL class " + routeClass.getName(), (Throwable)ex);
        }
        List routes = builder.getRouteCollection().getRoutes();
        if (routes.isEmpty()) {
            throw new SwitchYardException("No routes found in Java DSL class " + routeClass.getName());
        }
        if (routes.size() > 1) {
            throw new SwitchYardException("Only one route allowed per Java DSL class " + routeClass.getName());
        }
        route = (RouteDefinition)routes.get(0);
        if (route.getInputs().size() != 1) {
            throw new SwitchYardException("Java DSL routes must contain a single 'from' " + routeClass.getName());
        }
        return route;
    }
}

