/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.Produce;
import org.apache.camel.Service;
import org.apache.camel.core.xml.CamelJMXAgentDefinition;
import org.apache.camel.impl.CamelPostProcessorHelper;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spring.util.ReflectionUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ReflectionUtils;

@XmlRootElement(name="beanPostProcessor")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private static final transient Log LOG = LogFactory.getLog(CamelBeanPostProcessor.class);
    @XmlTransient
    Set<String> prototypeBeans = new LinkedHashSet<String>();
    @XmlTransient
    private CamelContext camelContext;
    @XmlTransient
    private ApplicationContext applicationContext;
    @XmlTransient
    private CamelPostProcessorHelper postProcessor;
    @XmlTransient
    private String camelId;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Camel bean processing before initialization for bean: " + beanName));
        }
        if (!this.canPostProcessBean(bean, beanName)) {
            return bean;
        }
        if (this.camelContext == null && this.applicationContext.containsBean(this.camelId)) {
            this.setCamelContext((CamelContext)this.applicationContext.getBean(this.camelId));
        }
        this.injectFields(bean, beanName);
        this.injectMethods(bean, beanName);
        if (bean instanceof CamelContextAware && this.canSetCamelContext(bean, beanName)) {
            CamelContextAware contextAware = (CamelContextAware)bean;
            if (this.camelContext == null) {
                LOG.warn((Object)("No CamelContext defined yet so cannot inject into bean: " + beanName));
            } else {
                contextAware.setCamelContext(this.camelContext);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Camel bean processing after initialization for bean: " + beanName));
        }
        if (!this.canPostProcessBean(bean, beanName)) {
            return bean;
        }
        if (bean instanceof DefaultEndpoint) {
            DefaultEndpoint defaultEndpoint = (DefaultEndpoint)bean;
            defaultEndpoint.setEndpointUriIfNotSpecified(beanName);
        }
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.postProcessor = new CamelPostProcessorHelper(camelContext){

            protected RuntimeException createProxyInstantiationRuntimeException(Class<?> type, Endpoint endpoint, Exception e) {
                return new BeanInstantiationException(type, "Could not instantiate proxy of type " + type.getName() + " on endpoint " + endpoint, (Throwable)e);
            }

            protected boolean isSingleton(Object bean, String beanName) {
                if (CamelBeanPostProcessor.this.applicationContext == null || beanName == null) {
                    return super.isSingleton(bean, beanName);
                }
                return CamelBeanPostProcessor.this.applicationContext.isSingleton(beanName);
            }

            protected void startService(Service service, Object bean, String beanName) throws Exception {
                if (this.isSingleton(bean, beanName)) {
                    this.getCamelContext().addService((Object)service);
                } else {
                    ServiceHelper.startService((Object)service);
                    if (CamelBeanPostProcessor.this.prototypeBeans.add(beanName)) {
                        LOG.warn((Object)("The bean with id [" + beanName + "] is prototype scoped and cannot stop the injected service when bean is destroyed: " + service + ". You may want to stop the service manually from the bean."));
                    }
                }
            }
        };
    }

    public String getCamelId() {
        return this.camelId;
    }

    public void setCamelId(String camelId) {
        this.camelId = camelId;
    }

    protected boolean canPostProcessBean(Object bean, String beanName) {
        return !(bean instanceof CamelJMXAgentDefinition);
    }

    protected boolean canSetCamelContext(Object bean, String beanName) {
        CamelContextAware camelContextAware;
        CamelContext context;
        if (bean instanceof CamelContextAware && (context = (camelContextAware = (CamelContextAware)bean).getCamelContext()) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("CamelContext already set on bean with id [" + beanName + "]. Will keep existing CamelContext on bean."));
            }
            return false;
        }
        return true;
    }

    protected void injectFields(final Object bean, final String beanName) {
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                Produce produce;
                EndpointInject endpointInject = field.getAnnotation(EndpointInject.class);
                if (endpointInject != null && CamelBeanPostProcessor.this.postProcessor.matchContext(endpointInject.context())) {
                    CamelBeanPostProcessor.this.injectField(field, endpointInject.uri(), endpointInject.ref(), bean, beanName);
                }
                if ((produce = field.getAnnotation(Produce.class)) != null && CamelBeanPostProcessor.this.postProcessor.matchContext(produce.context())) {
                    CamelBeanPostProcessor.this.injectField(field, produce.uri(), produce.ref(), bean, beanName);
                }
            }
        });
    }

    protected void injectField(Field field, String endpointUri, String endpointRef, Object bean, String beanName) {
        ReflectionUtils.setField(field, bean, this.getPostProcessor().getInjectionValue(field.getType(), endpointUri, endpointRef, field.getName(), bean, beanName));
    }

    protected void injectMethods(final Object bean, final String beanName) {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                CamelBeanPostProcessor.this.setterInjection(method, bean, beanName);
                CamelBeanPostProcessor.this.getPostProcessor().consumerInjection(method, bean, beanName);
            }
        });
    }

    protected void setterInjection(Method method, Object bean, String beanName) {
        Produce produce;
        EndpointInject endpointInject = method.getAnnotation(EndpointInject.class);
        if (endpointInject != null && this.postProcessor.matchContext(endpointInject.context())) {
            this.setterInjection(method, bean, beanName, endpointInject.uri(), endpointInject.ref());
        }
        if ((produce = method.getAnnotation(Produce.class)) != null && this.postProcessor.matchContext(produce.context())) {
            this.setterInjection(method, bean, beanName, produce.uri(), produce.ref());
        }
    }

    protected void setterInjection(Method method, Object bean, String beanName, String endpointUri, String endpointRef) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes != null) {
            if (parameterTypes.length != 1) {
                LOG.warn((Object)("Ignoring badly annotated method for injection due to incorrect number of parameters: " + method));
            } else {
                String propertyName = ObjectHelper.getPropertyName((Method)method);
                Object value = this.getPostProcessor().getInjectionValue(parameterTypes[0], endpointUri, endpointRef, propertyName, bean, beanName);
                ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{value});
            }
        }
    }

    public CamelPostProcessorHelper getPostProcessor() {
        ObjectHelper.notNull((Object)this.postProcessor, (String)"postProcessor");
        return this.postProcessor;
    }
}

