/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageScanRouteBuilderFinder {
    private static final transient Log LOG = LogFactory.getLog(PackageScanRouteBuilderFinder.class);
    private final SpringCamelContext camelContext;
    private final String[] packages;
    private final PackageScanClassResolver resolver;
    private final ApplicationContext applicationContext;
    private final BeanPostProcessor beanPostProcessor;

    public PackageScanRouteBuilderFinder(SpringCamelContext camelContext, String[] packages, ClassLoader classLoader, BeanPostProcessor postProcessor, PackageScanClassResolver resolver) {
        this.camelContext = camelContext;
        this.applicationContext = camelContext.getApplicationContext();
        this.packages = packages;
        this.beanPostProcessor = postProcessor;
        this.resolver = resolver;
        resolver.addClassLoader(classLoader);
    }

    public void appendBuilders(List<RoutesBuilder> list) throws IllegalAccessException, InstantiationException {
        Set classes = this.resolver.findImplementations(RoutesBuilder.class, this.packages);
        for (Class aClass : classes) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Found RouteBuilder class: " + aClass));
            }
            if (this.shouldIgnoreBean(aClass)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Ignoring RouteBuilder class: " + aClass));
                continue;
            }
            if (!this.isValidClass(aClass)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Ignoring invalid RouteBuilder class: " + aClass));
                continue;
            }
            RoutesBuilder builder = this.instantiateBuilder(aClass);
            if (this.beanPostProcessor != null) {
                this.beanPostProcessor.postProcessBeforeInitialization((Object)builder, builder.toString());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding instantiated RouteBuilder: " + builder));
            }
            list.add(builder);
        }
    }

    protected boolean shouldIgnoreBean(Class<?> type) {
        Map beans = this.applicationContext.getBeansOfType(type, true, true);
        return beans != null && !beans.isEmpty();
    }

    protected boolean isValidClass(Class type) {
        return !Modifier.isAbstract(type.getModifiers()) && !type.isInterface();
    }

    protected RoutesBuilder instantiateBuilder(Class type) throws IllegalAccessException, InstantiationException {
        return (RoutesBuilder)this.camelContext.getInjector().newInstance(type);
    }
}

