/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel;

import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.model.RouteDefinition;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceReference;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.camel.SwitchYardRouteDefinition;
import org.switchyard.component.camel.config.model.CamelBindingModel;
import org.switchyard.component.camel.config.model.OperationSelector;
import org.switchyard.exception.SwitchYardException;

public class InboundHandler
implements ExchangeHandler {
    private final CamelBindingModel _camelBindingModel;
    private final CamelContext _camelContext;
    private RouteDefinition _routeDefinition;

    public InboundHandler(CamelBindingModel camelBindingModel, CamelContext camelContext, QName serviceName) {
        this._camelBindingModel = camelBindingModel;
        this._camelContext = camelContext;
        this._routeDefinition = this.createRouteDefinition(serviceName);
        try {
            this._camelContext.addRouteDefinition(this._routeDefinition);
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    private RouteDefinition createRouteDefinition(QName serviceName) {
        SwitchYardRouteDefinition rd = new SwitchYardRouteDefinition(serviceName.getNamespaceURI());
        String routeId = serviceName.toString() + "-[" + this._camelBindingModel.getComponentURI() + "]";
        return (RouteDefinition)rd.routeId(routeId).from(this.uriFromBindingModel()).to(this.composeSwitchYardComponentName(serviceName));
    }

    private String uriFromBindingModel() {
        return this._camelBindingModel.getComponentURI().toString();
    }

    private String composeSwitchYardComponentName(QName serviceName) {
        StringBuilder sb = new StringBuilder().append("switchyard://").append(serviceName.getLocalPart());
        String operationName = this.operationName();
        if (operationName != null) {
            sb.append("?operationName=").append(operationName);
        }
        String namespace = this.namespace(serviceName);
        return SwitchYardRouteDefinition.addNamespaceParameter(sb.toString(), namespace);
    }

    public void start(ServiceReference serviceReference) throws Exception {
        if (this._routeDefinition.getStatus(this._camelContext).isStartable()) {
            this._camelContext.startRoute(this._routeDefinition);
        }
    }

    public void stop(ServiceReference serviceRef) throws Exception {
        String routeId = this._routeDefinition.getId();
        Route route = this._camelContext.getRoute(routeId);
        if (route.supportsSuspension()) {
            this._camelContext.suspendRoute(routeId);
        } else {
            this._camelContext.stopRoute(routeId);
        }
    }

    private String namespace(QName serviceName) {
        String namespace = null;
        OperationSelector os = this._camelBindingModel.getOperationSelector();
        if (os != null) {
            namespace = Strings.trimToNull((String)this._camelBindingModel.getOperationSelector().getNamespace());
        }
        if (namespace == null) {
            namespace = Strings.trimToNull((String)serviceName.getNamespaceURI());
        }
        return namespace;
    }

    private String operationName() {
        OperationSelector os = this._camelBindingModel.getOperationSelector();
        if (os != null) {
            return Strings.trimToNull((String)this._camelBindingModel.getOperationSelector().getOperationName());
        }
        return null;
    }

    public void handleMessage(Exchange switchYardExchange) {
    }

    public void handleFault(Exchange exchange) {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._camelBindingModel == null ? 0 : this._camelBindingModel.getComponentURI().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InboundHandler other = (InboundHandler)obj;
        return !(this._camelBindingModel == null ? other._camelBindingModel != null : !this._camelBindingModel.getComponentURI().equals(other._camelBindingModel.getComponentURI()));
    }
}

