/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel;

import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.impl.DefaultProducer;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.Message;
import org.switchyard.ServiceReference;
import org.switchyard.component.camel.CamelResponseHandler;
import org.switchyard.component.camel.deploy.ComponentNameComposer;
import org.switchyard.component.camel.deploy.ServiceReferences;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.BaseExchangeContract;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.InOnlyOperation;
import org.switchyard.metadata.InOutOperation;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.metadata.java.JavaService;

public class SwitchYardProducer
extends DefaultProducer {
    private String _namespace;
    private String _operationName;

    public SwitchYardProducer(Endpoint endpoint, String namespace, String operationName) {
        super(endpoint);
        this._namespace = namespace;
        this._operationName = operationName;
    }

    public void process(org.apache.camel.Exchange camelExchange) throws Exception {
        String targetUri = (String)camelExchange.getProperty("CamelToEndpoint");
        ServiceReference serviceRef = this.lookupServiceReference(targetUri);
        if (this._operationName == null) {
            this._operationName = this.lookupOperationNameFor(serviceRef);
        }
        Exchange switchyardExchange = this.createSwitchyardExchange(camelExchange, serviceRef);
        Object camelPayload = camelExchange.getIn().getBody();
        Message switchyardMsg = switchyardExchange.createMessage().setContent(camelPayload);
        switchyardExchange.send(switchyardMsg);
    }

    private ServiceReference lookupServiceReference(String targetUri) {
        QName serviceName = ComponentNameComposer.composeSwitchYardServiceName(this._namespace, targetUri);
        ServiceReference serviceRef = ServiceReferences.get(serviceName);
        if (serviceRef == null) {
            throw new NullPointerException("No ServiceReference was found for uri [" + targetUri + "]");
        }
        return serviceRef;
    }

    private Exchange createSwitchyardExchange(org.apache.camel.Exchange camelExchange, ServiceReference serviceRef) {
        return this.isInOnly(camelExchange.getPattern()) ? this.createInOnlyExchange(serviceRef, camelExchange) : this.createInOutExchange(serviceRef, camelExchange);
    }

    private boolean isInOnly(ExchangePattern pattern) {
        return pattern == ExchangePattern.InOnly;
    }

    private Exchange createInOnlyExchange(ServiceReference serviceReference, org.apache.camel.Exchange ex) {
        QName operationInputType = this.getOperationInputType(serviceReference);
        InOnlyOperation inOnlyOperation = new InOnlyOperation(this._operationName, operationInputType);
        BaseExchangeContract contract = new BaseExchangeContract((ServiceOperation)inOnlyOperation);
        this.setInputMessageType(contract, this.getCamelBodyType(ex));
        return serviceReference.createExchange((ExchangeContract)contract);
    }

    private String lookupOperationNameFor(ServiceReference serviceRef) {
        Set operations = serviceRef.getInterface().getOperations();
        if (operations.size() != 1) {
            StringBuilder msg = new StringBuilder();
            msg.append("No operationSelector was configured for the Camel Component and the Service Interface ");
            msg.append("contains more than one operation: ").append(operations);
            msg.append("Please add an operationSelector element with the target 'operationName' as an attribute.");
            throw new SwitchYardException(msg.toString());
        }
        ServiceOperation serviceOperation = (ServiceOperation)operations.iterator().next();
        return serviceOperation.getName();
    }

    private Exchange createInOutExchange(ServiceReference ref, org.apache.camel.Exchange camelExchange) {
        QName operationInputType = this.getOperationInputType(ref);
        QName operationOutputType = this.getOperationOutputType(ref);
        InOutOperation inOutOperation = new InOutOperation(this._operationName, operationInputType, operationOutputType);
        BaseExchangeContract exchangeContract = new BaseExchangeContract((ServiceOperation)inOutOperation);
        this.setInputMessageType(exchangeContract, this.getCamelBodyType(camelExchange));
        return ref.createExchange((ExchangeContract)exchangeContract, (ExchangeHandler)new CamelResponseHandler(camelExchange, ref));
    }

    private QName getOperationInputType(ServiceReference ref) {
        ServiceOperation operation = ref.getInterface().getOperation(this._operationName);
        if (operation != null) {
            return operation.getInputType();
        }
        return null;
    }

    private QName getOperationOutputType(ServiceReference ref) {
        ServiceInterface serviceInterface = ref.getInterface();
        ServiceOperation operation = serviceInterface.getOperation(this._operationName);
        if (operation != null) {
            return operation.getOutputType();
        }
        return null;
    }

    private void setInputMessageType(BaseExchangeContract exchangeContract, Class<?> type) {
        exchangeContract.getInvokerInvocationMetaData().setInputType(JavaService.toMessageType(type));
    }

    private Class<?> getCamelBodyType(org.apache.camel.Exchange exchange) {
        Object camelPayload = exchange.getIn().getBody();
        if (camelPayload == null) {
            return null;
        }
        return camelPayload.getClass();
    }
}

