/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel;

import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.impl.DefaultProducer;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.Message;
import org.switchyard.ServiceReference;
import org.switchyard.component.camel.CamelResponseHandler;
import org.switchyard.component.camel.composer.CamelMessageComposer;
import org.switchyard.component.camel.deploy.ComponentNameComposer;
import org.switchyard.component.camel.deploy.ServiceReferences;
import org.switchyard.composer.MessageComposer;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.BaseExchangeContract;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.InOnlyOperation;
import org.switchyard.metadata.InOutOperation;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.metadata.java.JavaService;
import org.switchyard.policy.ExchangePolicy;
import org.switchyard.policy.Policy;
import org.switchyard.policy.TransactionPolicy;

public class SwitchYardProducer
extends DefaultProducer {
    private String _namespace;
    private String _operationName;
    private final MessageComposer<org.apache.camel.Message> _messageComposer;

    public SwitchYardProducer(Endpoint endpoint, String namespace, String operationName, MessageComposer<org.apache.camel.Message> messageComposer) {
        super(endpoint);
        this._namespace = namespace;
        this._operationName = operationName;
        this._messageComposer = messageComposer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(org.apache.camel.Exchange camelExchange) throws Exception {
        String targetUri = (String)camelExchange.getProperty("CamelToEndpoint");
        final ServiceReference serviceRef = this.lookupServiceReference(targetUri);
        if (this._operationName == null) {
            this._operationName = this.lookupOperationNameFor(serviceRef);
        }
        Exchange switchyardExchange = this.createSwitchyardExchange(camelExchange, serviceRef);
        final SwitchYardProducer producer = this;
        if (camelExchange.isTransacted()) {
            ExchangePolicy.provide((Exchange)switchyardExchange, (Policy)TransactionPolicy.PROPAGATE);
        }
        CamelMessageComposer.ContentTypeProvider ctp = new CamelMessageComposer.ContentTypeProvider(){

            @Override
            public Class<?> getContentType() {
                return producer.getInputType(serviceRef);
            }
        };
        try {
            CamelMessageComposer.setContentTypeProvider(switchyardExchange, ctp);
            Message switchyardMessage = this._messageComposer.compose((Object)camelExchange.getIn(), switchyardExchange, true);
            switchyardExchange.send(switchyardMessage);
        }
        finally {
            CamelMessageComposer.setContentTypeProvider(switchyardExchange, null);
        }
    }

    private ServiceReference lookupServiceReference(String targetUri) {
        QName serviceName = ComponentNameComposer.composeSwitchYardServiceName(this._namespace, targetUri);
        ServiceReference serviceRef = ServiceReferences.get(serviceName);
        if (serviceRef == null) {
            throw new NullPointerException("No ServiceReference was found for uri [" + targetUri + "]");
        }
        return serviceRef;
    }

    private Exchange createSwitchyardExchange(org.apache.camel.Exchange camelExchange, ServiceReference serviceRef) {
        return this.isInOnly(camelExchange.getPattern()) ? this.createInOnlyExchange(serviceRef, camelExchange) : this.createInOutExchange(serviceRef, camelExchange);
    }

    private boolean isInOnly(ExchangePattern pattern) {
        return pattern == ExchangePattern.InOnly;
    }

    private Exchange createInOnlyExchange(ServiceReference ref, org.apache.camel.Exchange ex) {
        QName operationInputType = this.getOperationInputType(ref);
        InOnlyOperation inOnlyOperation = new InOnlyOperation(this._operationName, operationInputType);
        BaseExchangeContract contract = new BaseExchangeContract((ServiceOperation)inOnlyOperation);
        this.setInputMessageType(contract, operationInputType);
        return ref.createExchange((ExchangeContract)contract, (ExchangeHandler)new CamelResponseHandler(ex, ref, this._messageComposer));
    }

    private String lookupOperationNameFor(ServiceReference serviceRef) {
        Set operations = serviceRef.getInterface().getOperations();
        if (operations.size() != 1) {
            StringBuilder msg = new StringBuilder();
            msg.append("No operationSelector was configured for the Camel Component and the Service Interface ");
            msg.append("contains more than one operation: ").append(operations);
            msg.append("Please add an operationSelector element with the target 'operationName' as an attribute.");
            throw new SwitchYardException(msg.toString());
        }
        ServiceOperation serviceOperation = (ServiceOperation)operations.iterator().next();
        return serviceOperation.getName();
    }

    private Exchange createInOutExchange(ServiceReference ref, org.apache.camel.Exchange camelExchange) {
        QName operationInputType = this.getOperationInputType(ref);
        QName operationOutputType = this.getOperationOutputType(ref);
        InOutOperation inOutOperation = new InOutOperation(this._operationName, operationInputType, operationOutputType);
        BaseExchangeContract exchangeContract = new BaseExchangeContract((ServiceOperation)inOutOperation);
        this.setInputMessageType(exchangeContract, operationInputType);
        return ref.createExchange((ExchangeContract)exchangeContract, (ExchangeHandler)new CamelResponseHandler(camelExchange, ref, this._messageComposer));
    }

    private QName getOperationInputType(ServiceReference ref) {
        ServiceOperation operation = this.getOperation(ref);
        if (operation != null) {
            return operation.getInputType();
        }
        return null;
    }

    private QName getOperationOutputType(ServiceReference ref) {
        ServiceOperation operation = this.getOperation(ref);
        if (operation != null) {
            return operation.getOutputType();
        }
        return null;
    }

    private ServiceOperation getOperation(ServiceReference ref) {
        return ref.getInterface().getOperation(this._operationName);
    }

    private void setInputMessageType(BaseExchangeContract exchangeContract, QName type) {
        exchangeContract.getInvokerInvocationMetaData().setInputType(type);
    }

    private Class<?> getInputType(ServiceReference serviceRef) {
        QName inputType = this.getOperationInputType(serviceRef);
        if (inputType != null) {
            return JavaService.parseType((QName)inputType);
        }
        return Object.class;
    }
}

