/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel;

import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultConsumer;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.composer.MessageComposer;
import org.switchyard.exception.SwitchYardException;

public class SwitchYardConsumer
extends DefaultConsumer
implements ExchangeHandler {
    private final MessageComposer<org.apache.camel.Message> _messageComposer;

    public SwitchYardConsumer(Endpoint endpoint, Processor processor, MessageComposer<org.apache.camel.Message> messageComposer) {
        super(endpoint, processor);
        this._messageComposer = messageComposer;
    }

    public void handleMessage(Exchange switchyardExchange) throws HandlerException {
        org.apache.camel.Exchange camelExchange = this.createCamelExchange(switchyardExchange);
        this.invokeCamelProcessor(camelExchange);
        this.handleExceptionsFromCamel(camelExchange);
        if (this.isInOut(switchyardExchange)) {
            this.sendResponse(camelExchange, switchyardExchange);
        }
    }

    private void invokeCamelProcessor(org.apache.camel.Exchange camelExchange) throws HandlerException {
        try {
            this.getProcessor().process(camelExchange);
        }
        catch (Exception e) {
            throw new HandlerException((Throwable)e);
        }
    }

    private void handleExceptionsFromCamel(org.apache.camel.Exchange camelExchange) throws HandlerException {
        Exception camelException = camelExchange.getException();
        if (camelException != null) {
            throw new HandlerException((Throwable)camelException);
        }
        org.apache.camel.Message message = camelExchange.getOut();
        if (message.isFault()) {
            throw new HandlerException((String)message.getBody(String.class));
        }
    }

    private org.apache.camel.Exchange createCamelExchange(Exchange switchyardExchange) {
        org.apache.camel.Exchange camelExchange = this.isInOut(switchyardExchange) ? this.getEndpoint().createExchange(org.apache.camel.ExchangePattern.InOut) : this.getEndpoint().createExchange(org.apache.camel.ExchangePattern.InOnly);
        try {
            this._messageComposer.decompose(switchyardExchange, (Object)camelExchange.getIn());
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
        return camelExchange;
    }

    private void sendResponse(org.apache.camel.Exchange camelExchange, Exchange switchyardExchange) {
        Message switchyardMessage;
        org.apache.camel.Message camelMessage = camelExchange.getOut().getBody() != null ? camelExchange.getOut() : camelExchange.getIn();
        try {
            switchyardMessage = this._messageComposer.compose((Object)camelMessage, switchyardExchange, false);
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
        switchyardExchange.send(switchyardMessage);
    }

    private boolean isInOut(Exchange exchange) {
        return exchange.getContract().getServiceOperation().getExchangePattern() == ExchangePattern.IN_OUT;
    }

    public void handleFault(Exchange exchange) {
    }
}

