/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.config.model.mock.v1;

import java.net.URI;
import org.switchyard.component.camel.config.model.QueryString;
import org.switchyard.component.camel.config.model.mock.CamelMockBindingModel;
import org.switchyard.component.camel.config.model.v1.NameValueModel;
import org.switchyard.component.camel.config.model.v1.V1BaseCamelBindingModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;

public class V1CamelMockBindingModel
extends V1BaseCamelBindingModel
implements CamelMockBindingModel {
    public static final String MOCK = "mock";
    private static final String NAME = "name";
    private static final String REPORT_GROUP = "reportGroup";

    public V1CamelMockBindingModel() {
        super(MOCK);
        this.setModelChildrenOrder(new String[]{NAME, REPORT_GROUP});
    }

    public V1CamelMockBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    @Override
    public String getName() {
        return this.getConfig(NAME);
    }

    @Override
    public CamelMockBindingModel setName(String name) {
        this.setConfig(NAME, name);
        return this;
    }

    @Override
    public Integer getReportGroup() {
        return this.getIntegerConfig(REPORT_GROUP);
    }

    @Override
    public CamelMockBindingModel setReportGroup(Integer reportGroup) {
        this.setConfig(REPORT_GROUP, String.valueOf(reportGroup));
        return this;
    }

    @Override
    public URI getComponentURI() {
        String uriStr = "mock://" + this.getConfig(NAME);
        QueryString queryStr = new QueryString().add(REPORT_GROUP, this.getConfig(REPORT_GROUP));
        return URI.create(uriStr.toString() + queryStr);
    }

    private Integer getIntegerConfig(String configName) {
        String value = this.getConfig(configName);
        return value != null ? Integer.valueOf(Integer.parseInt(value)) : null;
    }

    private String getConfig(String configName) {
        Configuration config = this.getModelConfiguration().getFirstChild(configName);
        if (config != null) {
            return config.getValue();
        }
        return null;
    }

    private void setConfig(String name, String value) {
        Configuration config = this.getModelConfiguration().getFirstChild(name);
        if (config != null) {
            config.setValue(value);
        } else {
            NameValueModel model = new NameValueModel(name);
            model.setValue(value);
            this.setChildModel((Model)model);
        }
    }
}

