/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.deploy;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.Message;
import org.apache.camel.impl.CompositeRegistry;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.Registry;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceReference;
import org.switchyard.component.camel.InboundHandler;
import org.switchyard.component.camel.OutboundHandler;
import org.switchyard.component.camel.RouteFactory;
import org.switchyard.component.camel.SwitchYardConsumer;
import org.switchyard.component.camel.SwitchyardEndpoint;
import org.switchyard.component.camel.composer.CamelComposition;
import org.switchyard.component.camel.config.model.CamelBindingModel;
import org.switchyard.component.camel.config.model.CamelComponentImplementationModel;
import org.switchyard.component.camel.deploy.ComponentNameComposer;
import org.switchyard.component.camel.deploy.ServiceReferences;
import org.switchyard.composer.MessageComposer;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.exception.SwitchYardException;

public class CamelActivator
extends BaseActivator {
    private static final String CAMEL_TYPE = "camel";
    private static final String DIRECT_TYPE = "direct";
    private static final String FILE_TYPE = "file";
    private Map<QName, Set<InboundHandler>> _bindings = new HashMap<QName, Set<InboundHandler>>();
    private Map<QName, Set<OutboundHandler>> _references = new HashMap<QName, Set<OutboundHandler>>();
    private Map<QName, SwitchYardConsumer> _implementations = new HashMap<QName, SwitchYardConsumer>();
    private CamelContext _camelContext;

    public CamelActivator() {
        super(new String[]{CAMEL_TYPE, DIRECT_TYPE, FILE_TYPE});
    }

    public ExchangeHandler init(QName serviceName, Model config) {
        this.startCamelContext();
        if (this.isServiceBinding(config)) {
            return this.handleServiceBindings((CompositeServiceModel)config, serviceName);
        }
        if (this.isReferenceBinding(config)) {
            return this.handleReferenceBindings((CompositeReferenceModel)config, serviceName);
        }
        if (this.isComponentService(config)) {
            return this.handleImplementation((ComponentServiceModel)config, serviceName);
        }
        if (this.isComponentReference(config)) {
            return this.handleComponentReference((ComponentReferenceModel)config, serviceName);
        }
        throw new SwitchYardException("No Camel bindings, references or implementations found for [" + serviceName + "] in config [" + config + "]");
    }

    private void startCamelContext() {
        try {
            this._camelContext = new DefaultCamelContext(this.getRegistry());
            PackageScanClassResolver packageScanClassResolver = CamelActivator.getPackageScanClassResolver();
            if (packageScanClassResolver != null) {
                this._camelContext.setPackageScanClassResolver(packageScanClassResolver);
            }
            this._camelContext.start();
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    public static PackageScanClassResolver getPackageScanClassResolver() {
        ServiceLoader<PackageScanClassResolver> resolverLoaders = ServiceLoader.load(PackageScanClassResolver.class, CamelActivator.class.getClassLoader());
        Iterator<PackageScanClassResolver> i$ = resolverLoaders.iterator();
        if (i$.hasNext()) {
            PackageScanClassResolver packageScanClassResolver = i$.next();
            return packageScanClassResolver;
        }
        return null;
    }

    private ExchangeHandler handleComponentReference(ComponentReferenceModel config, QName serviceName) {
        MessageComposer<Message> messageComposer = CamelComposition.getMessageComposer();
        return this.addOutboundHandler(serviceName, ComponentNameComposer.composeComponentUri(serviceName), messageComposer);
    }

    private Registry getRegistry() throws NamingException {
        ServiceLoader<Registry> registriesLoaders = ServiceLoader.load(Registry.class, ((Object)((Object)this)).getClass().getClassLoader());
        ArrayList<Object> registries = new ArrayList<Object>();
        registries.add(new JndiRegistry());
        for (Registry registry : registriesLoaders) {
            registries.add(registry);
        }
        return new CompositeRegistry(registries);
    }

    private boolean isComponentReference(Model config) {
        return config instanceof ComponentReferenceModel;
    }

    private ExchangeHandler handleImplementation(ComponentServiceModel config, QName serviceName) {
        ComponentImplementationModel implementation = this.getComponentImplementationModel((Model)config);
        if (implementation instanceof CamelComponentImplementationModel) {
            CamelComponentImplementationModel ccim = (CamelComponentImplementationModel)implementation;
            try {
                String endpointUri = ComponentNameComposer.composeComponentUri(serviceName);
                RouteDefinition routeDef = this.getRouteDefinition(ccim);
                this.checkSwitchYardReferencedServiceExist(routeDef, ccim);
                this.addFromEndpointToRouteDefinition(routeDef, endpointUri);
                this._camelContext.addRouteDefinition(routeDef);
                SwitchyardEndpoint endpoint = (SwitchyardEndpoint)this._camelContext.getEndpoint(endpointUri);
                endpoint.setMessageComposer(CamelComposition.getMessageComposer());
                SwitchYardConsumer consumer = endpoint.getConsumer();
                this._implementations.put(serviceName, consumer);
                return consumer;
            }
            catch (Exception e) {
                throw new SwitchYardException(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private void checkSwitchYardReferencedServiceExist(RouteDefinition routeDef, CamelComponentImplementationModel ccim) {
        List outputs = routeDef.getOutputs();
        for (ProcessorDefinition processorDef : outputs) {
            ToDefinition to;
            URI componentUri;
            if (!(processorDef instanceof ToDefinition) || !(componentUri = URI.create((to = (ToDefinition)processorDef).getUri())).getScheme().equals("switchyard")) continue;
            String serviceName = componentUri.getHost();
            String namespace = ComponentNameComposer.getNamespaceFromURI(componentUri);
            QName refServiceName = new QName(namespace, serviceName);
            if (!this.containsServiceRef(ccim.getComponent().getReferences(), serviceName)) {
                throw new SwitchYardException("Could find the service reference for '" + serviceName + "'" + " which is referenced in " + to);
            }
            ServiceReference service = this.getServiceDomain().getService(refServiceName);
            if (service != null) continue;
            throw new SwitchYardException("Could find the service name '" + serviceName + "'" + " which is referenced in " + to);
        }
    }

    private boolean containsServiceRef(List<ComponentReferenceModel> refs, String serviceName) {
        for (ComponentReferenceModel refModel : refs) {
            if (!refModel.getName().equals(serviceName)) continue;
            return true;
        }
        return false;
    }

    private void addFromEndpointToRouteDefinition(RouteDefinition rd, String fromEndpointUri) throws Exception {
        List inputs = rd.getInputs();
        if (inputs.size() == 0) {
            inputs.add(new FromDefinition(fromEndpointUri));
        } else if (inputs.size() == 1) {
            String routeURI = ((FromDefinition)inputs.get(0)).getUri();
            if (!fromEndpointUri.equals(routeURI)) {
                throw new SwitchYardException("Endpoint URI on route " + routeURI + " does not match expected URI : " + fromEndpointUri);
            }
        } else {
            throw new SwitchYardException("A route can only have one 'from' endpoint");
        }
    }

    private RouteDefinition getRouteDefinition(CamelComponentImplementationModel model) {
        RouteDefinition routeDef = model.getRoute();
        if (routeDef == null) {
            routeDef = RouteFactory.createRoute(model.getJavaClass(), model.getComponent().getTargetNamespace());
        }
        return routeDef;
    }

    private boolean isComponentService(Model config) {
        return config instanceof ComponentServiceModel;
    }

    private boolean isReferenceBinding(Model config) {
        return config instanceof CompositeReferenceModel;
    }

    private boolean isServiceBinding(Model config) {
        return config instanceof CompositeServiceModel;
    }

    private ExchangeHandler handleReferenceBindings(CompositeReferenceModel config, QName serviceName) {
        List bindings = config.getBindings();
        if (!bindings.isEmpty()) {
            return this.createOutboundHandler(bindings, serviceName);
        }
        return null;
    }

    private ExchangeHandler handleServiceBindings(CompositeServiceModel serviceModel, QName serviceName) {
        List bindings = serviceModel.getBindings();
        if (!bindings.isEmpty()) {
            return this.createInboundHandler(bindings, serviceName);
        }
        return null;
    }

    private ComponentImplementationModel getComponentImplementationModel(Model config) {
        Model modelParent = config.getModelParent();
        ComponentModel componentModel = (ComponentModel)modelParent;
        return componentModel.getImplementation();
    }

    private InboundHandler createInboundHandler(List<BindingModel> bindings, QName name) {
        for (BindingModel bindingModel : bindings) {
            if (!this.isCamelBindingModel(bindingModel)) continue;
            CamelBindingModel camelBindingModel = (CamelBindingModel)bindingModel;
            try {
                InboundHandler inboundHandler;
                Set<InboundHandler> handlers = this.getInboundHandlersForService(name);
                if (handlers.contains(inboundHandler = new InboundHandler(camelBindingModel, this._camelContext, name))) continue;
                handlers.add(inboundHandler);
                this._bindings.put(name, handlers);
                return inboundHandler;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    private boolean isCamelBindingModel(BindingModel bm) {
        return bm instanceof CamelBindingModel;
    }

    private OutboundHandler createOutboundHandler(List<BindingModel> bindings, QName name) {
        for (BindingModel bindingModel : bindings) {
            if (!this.isCamelBindingModel(bindingModel)) continue;
            CamelBindingModel camelBinding = (CamelBindingModel)bindingModel;
            String endpointUri = camelBinding.getComponentURI().toString();
            MessageComposer<Message> messageComposer = CamelComposition.getMessageComposer(bindingModel);
            return this.addOutboundHandler(name, endpointUri, messageComposer);
        }
        return null;
    }

    private OutboundHandler addOutboundHandler(QName name, String uri, MessageComposer<Message> messageComposer) {
        try {
            Set<OutboundHandler> handlers = this.getOutboundHandlersForService(name);
            OutboundHandler outboundHandler = new OutboundHandler(uri, this._camelContext, messageComposer);
            if (!handlers.contains((Object)outboundHandler)) {
                handlers.add(outboundHandler);
                this._references.put(name, handlers);
                return outboundHandler;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    private Set<OutboundHandler> getOutboundHandlersForService(QName serviceName) {
        Set<OutboundHandler> handlers = this._references.get(serviceName);
        if (handlers == null) {
            handlers = new HashSet<OutboundHandler>();
        }
        return handlers;
    }

    private Set<InboundHandler> getInboundHandlersForService(QName serviceName) {
        Set<InboundHandler> handlers = this._bindings.get(serviceName);
        if (handlers == null) {
            handlers = new HashSet<InboundHandler>();
        }
        return handlers;
    }

    public void start(ServiceReference serviceReference) {
        ServiceReferences.add(serviceReference.getName(), serviceReference);
        this.startInboundHandlers(serviceReference);
    }

    public void stop(ServiceReference serviceReference) {
        this.stopInboundHandlers(serviceReference);
        ServiceReferences.remove(serviceReference.getName());
    }

    private void startInboundHandlers(ServiceReference serviceReference) {
        Set<InboundHandler> handlers = this._bindings.get(serviceReference.getName());
        if (handlers != null) {
            for (InboundHandler inboundHandler : handlers) {
                try {
                    inboundHandler.start(serviceReference);
                }
                catch (Exception e) {
                    throw new SwitchYardException((Throwable)e);
                }
            }
        }
    }

    public void destroy(ServiceReference service) {
        this._bindings.remove(service.getName());
        this.stopCamelContext();
    }

    private void stopInboundHandlers(ServiceReference serviceReference) {
        Set<InboundHandler> handlers = this._bindings.get(serviceReference.getName());
        if (handlers != null) {
            for (InboundHandler inboundHandler : handlers) {
                try {
                    inboundHandler.stop(serviceReference);
                }
                catch (Exception e) {
                    throw new SwitchYardException((Throwable)e);
                }
            }
        }
    }

    private void stopCamelContext() {
        try {
            this._camelContext.stop();
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    public void setCamelContext(CamelContext camelContext) {
        this._camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this._camelContext;
    }
}

