/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.config.model.v1;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.model.RouteDefinition;
import org.switchyard.component.camel.SwitchYardRouteDefinition;
import org.switchyard.component.camel.config.model.CamelComponentImplementationModel;
import org.switchyard.component.camel.config.model.v1.NameValueModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.v1.V1ComponentImplementationModel;
import org.switchyard.exception.SwitchYardException;

public class V1CamelImplementationModel
extends V1ComponentImplementationModel
implements CamelComponentImplementationModel {
    private static final String CLASS = "class";
    private static JAXBContext jaxbContext = V1CamelImplementationModel.createJAXBInstance();

    public V1CamelImplementationModel() {
        super("camel", "urn:switchyard-component-camel:config:1.0");
    }

    public V1CamelImplementationModel(Configuration config, Descriptor desc) {
        super(config, desc);
        this.setModelChildrenOrder(new String[0]);
    }

    @Override
    public RouteDefinition getRoute() {
        RouteDefinition route;
        Configuration routeConfig = this.getModelConfiguration().getFirstChild("route");
        if (routeConfig == null) {
            return null;
        }
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            route = (RouteDefinition)unmarshaller.unmarshal(routeConfig.getSource());
        }
        catch (JAXBException e) {
            throw new SwitchYardException((Throwable)e);
        }
        String namespace = this.getComponent().getTargetNamespace();
        if (route != null && namespace != null) {
            SwitchYardRouteDefinition.addNamespaceParameter(route, namespace);
        }
        return route;
    }

    private static JAXBContext createJAXBInstance() {
        try {
            return JAXBContext.newInstance((String)"org.apache.camel:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer");
        }
        catch (JAXBException e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    @Override
    public String getJavaClass() {
        Configuration classConfig = this.getModelConfiguration().getFirstChild("java");
        return classConfig != null ? classConfig.getAttribute(CLASS) : null;
    }

    @Override
    public V1CamelImplementationModel setJavaClass(String className) {
        Configuration classConfig = this.getModelConfiguration().getFirstChild("java");
        if (classConfig == null) {
            NameValueModel model = new NameValueModel("java");
            model.getModelConfiguration().setAttribute(CLASS, className);
            this.setChildModel((Model)model);
        } else {
            classConfig.setAttribute(CLASS, className);
        }
        return this;
    }
}

