/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.deploy;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.Message;
import org.apache.camel.impl.CompositeRegistry;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.Registry;
import org.switchyard.ServiceReference;
import org.switchyard.component.camel.InboundHandler;
import org.switchyard.component.camel.OutboundHandler;
import org.switchyard.component.camel.RouteFactory;
import org.switchyard.component.camel.SwitchYardConsumer;
import org.switchyard.component.camel.SwitchyardEndpoint;
import org.switchyard.component.camel.composer.CamelComposition;
import org.switchyard.component.camel.config.model.CamelBindingModel;
import org.switchyard.component.camel.config.model.CamelComponentImplementationModel;
import org.switchyard.component.camel.deploy.ComponentNameComposer;
import org.switchyard.composer.MessageComposer;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.deploy.ServiceHandler;
import org.switchyard.exception.SwitchYardException;

public class CamelActivator
extends BaseActivator {
    public static final String SERVICE_DOMAIN = "org.switchyard.camel.serviceDomain";
    private static final String CAMEL_TYPE = "camel";
    private static final String DIRECT_TYPE = "direct";
    private static final String FILE_TYPE = "file";
    private CamelContext _camelContext;
    private Configuration _environment;

    public CamelActivator() {
        super(new String[]{CAMEL_TYPE, DIRECT_TYPE, FILE_TYPE});
    }

    public ServiceHandler activateBinding(QName serviceName, BindingModel config) {
        this.start();
        CamelBindingModel binding = (CamelBindingModel)config;
        binding.setEnvironment(this._environment);
        if (binding.isServiceBinding()) {
            return new InboundHandler(binding, this._camelContext, serviceName);
        }
        return this.createOutboundHandler(binding, binding.getReference().getQName());
    }

    public ServiceHandler activateService(QName serviceName, ComponentModel config) {
        this.start();
        ServiceHandler handler = null;
        for (ComponentServiceModel service : config.getServices()) {
            if (!service.getQName().equals(serviceName)) continue;
            handler = this.handleImplementation(service, serviceName);
            break;
        }
        return handler;
    }

    public void start() {
        this.startCamelContext();
    }

    public void stop() {
        this.stopCamelContext();
    }

    public void destroy() {
        this.stop();
    }

    public void deactivateBinding(QName name, ServiceHandler handler) {
    }

    public void deactivateService(QName name, ServiceHandler handler) {
    }

    private synchronized void startCamelContext() {
        if (this._camelContext == null) {
            try {
                this._camelContext = new DefaultCamelContext(this.getRegistry());
                PackageScanClassResolver packageScanClassResolver = CamelActivator.getPackageScanClassResolver();
                if (packageScanClassResolver != null) {
                    this._camelContext.setPackageScanClassResolver(packageScanClassResolver);
                }
                this._camelContext.start();
            }
            catch (Exception e) {
                throw new SwitchYardException((Throwable)e);
            }
        }
    }

    private synchronized void stopCamelContext() {
        if (this._camelContext != null) {
            try {
                this._camelContext.stop();
                this._camelContext = null;
            }
            catch (Exception ex) {
                throw new SwitchYardException("CamelActivator failed to stop CamelContext.", (Throwable)ex);
            }
        }
    }

    public static PackageScanClassResolver getPackageScanClassResolver() {
        ServiceLoader<PackageScanClassResolver> resolverLoaders = ServiceLoader.load(PackageScanClassResolver.class, CamelActivator.class.getClassLoader());
        Iterator<PackageScanClassResolver> i$ = resolverLoaders.iterator();
        if (i$.hasNext()) {
            PackageScanClassResolver packageScanClassResolver = i$.next();
            return packageScanClassResolver;
        }
        return null;
    }

    private Registry getRegistry() throws NamingException {
        ServiceLoader<Registry> registriesLoaders = ServiceLoader.load(Registry.class, ((Object)((Object)this)).getClass().getClassLoader());
        ArrayList<Object> registries = new ArrayList<Object>();
        registries.add(new JndiRegistry());
        for (Registry registry : registriesLoaders) {
            registries.add(registry);
        }
        SimpleRegistry syProps = new SimpleRegistry();
        syProps.put((Object)SERVICE_DOMAIN, (Object)this.getServiceDomain());
        registries.add(syProps);
        return new CompositeRegistry(registries);
    }

    private ServiceHandler handleImplementation(ComponentServiceModel config, QName serviceName) {
        CamelComponentImplementationModel ccim = (CamelComponentImplementationModel)config.getComponent().getImplementation();
        try {
            String endpointUri = ComponentNameComposer.composeComponentUri(serviceName);
            RouteDefinition routeDef = this.getRouteDefinition(ccim);
            this.checkSwitchYardReferencedServiceExist(routeDef, ccim);
            this.addFromEndpointToRouteDefinition(routeDef, endpointUri);
            this._camelContext.addRouteDefinition(routeDef);
            SwitchyardEndpoint endpoint = (SwitchyardEndpoint)this._camelContext.getEndpoint(endpointUri);
            endpoint.setMessageComposer(CamelComposition.getMessageComposer());
            SwitchYardConsumer consumer = endpoint.getConsumer();
            return consumer;
        }
        catch (Exception e) {
            throw new SwitchYardException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkSwitchYardReferencedServiceExist(RouteDefinition routeDef, CamelComponentImplementationModel ccim) {
        List outputs = routeDef.getOutputs();
        for (ProcessorDefinition processorDef : outputs) {
            ToDefinition to;
            URI componentUri;
            if (!(processorDef instanceof ToDefinition) || !(componentUri = URI.create((to = (ToDefinition)processorDef).getUri())).getScheme().equals("switchyard")) continue;
            String serviceName = componentUri.getHost();
            String namespace = ComponentNameComposer.getNamespaceFromURI(componentUri);
            QName refServiceName = new QName(namespace, serviceName);
            if (!this.containsServiceRef(ccim.getComponent().getReferences(), serviceName)) {
                throw new SwitchYardException("Could find the service reference for '" + serviceName + "'" + " which is referenced in " + to);
            }
            ServiceReference service = this.getServiceDomain().getServiceReference(refServiceName);
            if (service != null) continue;
            throw new SwitchYardException("Could find the service name '" + serviceName + "'" + " which is referenced in " + to);
        }
    }

    private boolean containsServiceRef(List<ComponentReferenceModel> refs, String serviceName) {
        for (ComponentReferenceModel refModel : refs) {
            if (!refModel.getName().equals(serviceName)) continue;
            return true;
        }
        return false;
    }

    private void addFromEndpointToRouteDefinition(RouteDefinition rd, String fromEndpointUri) throws Exception {
        List inputs = rd.getInputs();
        if (inputs.size() == 0) {
            inputs.add(new FromDefinition(fromEndpointUri));
        } else if (inputs.size() == 1) {
            String routeURI = ((FromDefinition)inputs.get(0)).getUri();
            if (!fromEndpointUri.equals(routeURI)) {
                throw new SwitchYardException("Endpoint URI on route " + routeURI + " does not match expected URI : " + fromEndpointUri);
            }
        } else {
            throw new SwitchYardException("A route can only have one 'from' endpoint");
        }
    }

    private RouteDefinition getRouteDefinition(CamelComponentImplementationModel model) {
        RouteDefinition routeDef = model.getRoute();
        if (routeDef == null) {
            routeDef = RouteFactory.createRoute(model.getJavaClass(), model.getComponent().getTargetNamespace());
        }
        return routeDef;
    }

    private ServiceHandler createOutboundHandler(CamelBindingModel binding, QName name) {
        String endpointUri = binding.getComponentURI().toString();
        MessageComposer<Message> messageComposer = CamelComposition.getMessageComposer(binding);
        return new OutboundHandler(endpointUri, this._camelContext, messageComposer);
    }

    public void setCamelContext(CamelContext camelContext) {
        this._camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this._camelContext;
    }

    public void setEnvironment(Configuration config) {
        this._environment = config;
    }
}

