/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.switchyard.Exchange;
import org.switchyard.common.type.Classes;
import org.switchyard.component.camel.processor.DefaultProcessor;
import org.switchyard.composer.MessageComposer;
import org.switchyard.metadata.InOnlyOperation;
import org.switchyard.metadata.InOutOperation;
import org.switchyard.metadata.java.JavaService;

public class CxfRsHttpDynamicProcessor
extends DefaultProcessor {
    private Map<String, RsMethod> _resourcePaths = new HashMap<String, RsMethod>();

    public CxfRsHttpDynamicProcessor(MessageComposer composer, Exchange exchange, String uri) {
        super(composer, exchange);
        String resourceClasses = uri.split("resourceClasses=")[1].split("&")[0];
        StringTokenizer st = new StringTokenizer(resourceClasses);
        while (st.hasMoreTokens()) {
            String className = st.nextToken();
            Class clazz = Classes.forName((String)className);
            if (clazz == null) {
                throw new RuntimeException("Unable to load class " + className);
            }
            String classLevelPath = "";
            Path path = clazz.getAnnotation(Path.class);
            if (path != null) {
                classLevelPath = path.value();
            }
            for (Method m : clazz.getDeclaredMethods()) {
                if (!Modifier.isPublic(m.getModifiers())) continue;
                Class<?>[] params = m.getParameterTypes();
                if (params.length > 1) {
                    throw new RuntimeException("Service operations on a REST interface must have none or exactly one parameter. " + m.getName());
                }
                JavaService.OperationTypeQNames operationTypeNames = new JavaService.OperationTypeQNames(m);
                Object op = null;
                op = m.getReturnType().equals(Void.TYPE) ? new InOnlyOperation(m.getName(), operationTypeNames.in()) : new InOutOperation(m.getName(), operationTypeNames.in(), operationTypeNames.out(), operationTypeNames.fault());
                String methodPath = classLevelPath;
                String paramName = null;
                path = m.getAnnotation(Path.class);
                Boolean foundPathParam = false;
                if (path != null) {
                    Annotation[][] paramAnnotations = m.getParameterAnnotations();
                    if (paramAnnotations.length > 0 && paramAnnotations[0].length > 0) {
                        for (Annotation anno : paramAnnotations[0]) {
                            if (!(anno instanceof PathParam)) continue;
                            paramName = ((PathParam)anno).value();
                            foundPathParam = true;
                            break;
                        }
                    }
                    methodPath = foundPathParam != false ? methodPath + path.value().substring(0, path.value().indexOf("{")) : methodPath + path.value();
                }
                if (m.getAnnotation(DELETE.class) != null) {
                    this._resourcePaths.put(op.toString(), new RsMethod(methodPath, "DELETE", paramName, m.getReturnType(), foundPathParam));
                    continue;
                }
                if (m.getAnnotation(PUT.class) != null) {
                    this._resourcePaths.put(op.toString(), new RsMethod(methodPath, "PUT", paramName, m.getReturnType(), foundPathParam));
                    continue;
                }
                if (m.getAnnotation(POST.class) != null) {
                    this._resourcePaths.put(op.toString(), new RsMethod(methodPath, "POST", paramName, m.getReturnType(), foundPathParam));
                    continue;
                }
                if (m.getAnnotation(OPTIONS.class) != null) {
                    this._resourcePaths.put(op.toString(), new RsMethod(methodPath, "OPTIONS", paramName, m.getReturnType(), foundPathParam));
                    continue;
                }
                if (m.getAnnotation(HEAD.class) != null) {
                    this._resourcePaths.put(op.toString(), new RsMethod(methodPath, "HEAD", paramName, m.getReturnType(), foundPathParam));
                    continue;
                }
                if (m.getAnnotation(GET.class) != null) {
                    this._resourcePaths.put(op.toString(), new RsMethod(methodPath, "GET", paramName, m.getReturnType(), foundPathParam));
                    continue;
                }
                throw new RuntimeException("Encountered unknown REST method type.");
            }
        }
    }

    @Override
    public void process(org.apache.camel.Exchange camelExchange) throws Exception {
        RsMethod restMethod = this._resourcePaths.get(this.getExchange().getContract().getServiceOperation().toString());
        if (restMethod == null) {
            throw new RuntimeException("Could not map " + this.getExchange().getContract().getServiceOperation().getName() + " to any REST method.");
        }
        camelExchange.getIn().setHeader("CamelCxfRsUsingHttpAPI", (Object)Boolean.TRUE);
        camelExchange.getIn().setHeader("CamelCxfRsResponseClass", restMethod.getResponseType());
        camelExchange.getIn().setHeader("CamelHttpMethod", (Object)restMethod.getMethod());
        if (restMethod.hasPathParam().booleanValue()) {
            camelExchange.getIn().setHeader("CamelHttpPath", (Object)(restMethod.getPath() + "/" + this.getExchange().getMessage().getContent()));
        } else {
            camelExchange.getIn().setHeader("CamelHttpPath", (Object)restMethod.getPath());
        }
        super.process(camelExchange);
    }

    private class RsMethod {
        private String _path;
        private String _method;
        private String _paramName;
        private Class<?> _responseType;
        private Boolean _pathParam;

        public RsMethod(String path, String method, String paramName, Class<?> responseType, Boolean hasPathParam) {
            this._path = path;
            this._method = method;
            this._paramName = paramName;
            this._responseType = responseType;
            this._pathParam = hasPathParam;
        }

        public String getMethod() {
            return this._method;
        }

        public String getPath() {
            return this._path;
        }

        public String getParamName() {
            return this._paramName;
        }

        public Class<?> getResponseType() {
            return this._responseType;
        }

        public Boolean hasPathParam() {
            return this._pathParam;
        }
    }
}

