/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel;

import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultProducer;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.Message;
import org.switchyard.ServiceReference;
import org.switchyard.component.camel.CamelResponseHandler;
import org.switchyard.component.camel.deploy.ComponentNameComposer;
import org.switchyard.component.camel.deploy.ServiceReferences;
import org.switchyard.composer.MessageComposer;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.policy.ExchangePolicy;
import org.switchyard.policy.Policy;
import org.switchyard.policy.TransactionPolicy;

public class SwitchYardProducer
extends DefaultProducer {
    private String _namespace;
    private String _operationName;
    private final MessageComposer<org.apache.camel.Message> _messageComposer;

    public SwitchYardProducer(Endpoint endpoint, String namespace, String operationName, MessageComposer<org.apache.camel.Message> messageComposer) {
        super(endpoint);
        this._namespace = namespace;
        this._operationName = operationName;
        this._messageComposer = messageComposer;
    }

    public void process(org.apache.camel.Exchange camelExchange) throws Exception {
        String targetUri = (String)camelExchange.getProperty("CamelToEndpoint");
        ServiceReference serviceRef = this.lookupServiceReference(targetUri);
        if (this._operationName == null) {
            this._operationName = this.lookupOperationNameFor(serviceRef);
        }
        Exchange switchyardExchange = this.createSwitchyardExchange(camelExchange, serviceRef);
        if (camelExchange.isTransacted()) {
            ExchangePolicy.provide((Exchange)switchyardExchange, (Policy)TransactionPolicy.PROPAGATE);
        }
        Message switchyardMessage = this._messageComposer.compose((Object)camelExchange.getIn(), switchyardExchange, true);
        switchyardExchange.send(switchyardMessage);
    }

    private ServiceReference lookupServiceReference(String targetUri) {
        QName serviceName = ComponentNameComposer.composeSwitchYardServiceName(this._namespace, targetUri);
        ServiceReference serviceRef = ServiceReferences.get(serviceName);
        if (serviceRef == null) {
            throw new NullPointerException("No ServiceReference was found for uri [" + targetUri + "]");
        }
        return serviceRef;
    }

    private Exchange createSwitchyardExchange(org.apache.camel.Exchange camelExchange, ServiceReference serviceRef) {
        return serviceRef.createExchange(this._operationName, (ExchangeHandler)new CamelResponseHandler(camelExchange, serviceRef, this._messageComposer));
    }

    private String lookupOperationNameFor(ServiceReference serviceRef) {
        Set operations = serviceRef.getInterface().getOperations();
        if (operations.size() != 1) {
            StringBuilder msg = new StringBuilder();
            msg.append("No operationSelector was configured for the Camel Component and the Service Interface ");
            msg.append("contains more than one operation: ").append(operations);
            msg.append("Please add an operationSelector element with the target 'operationName' as an attribute.");
            throw new SwitchYardException(msg.toString());
        }
        ServiceOperation serviceOperation = (ServiceOperation)operations.iterator().next();
        return serviceOperation.getName();
    }
}

