/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.composer;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.composer.BaseContextMapper;

public class CamelContextMapper
extends BaseContextMapper<Message> {
    private static final Scope[] IN_OUT = new Scope[]{Scope.IN, Scope.OUT};

    public void mapFrom(Message source, Context context) throws Exception {
        Object value;
        String name;
        Exchange exchange = source.getExchange();
        Scope scope = exchange.getIn() == source ? Scope.IN : Scope.OUT;
        for (Map.Entry header : source.getHeaders().entrySet()) {
            name = (String)header.getKey();
            if (!this.matches(name) || (value = header.getValue()) == null) continue;
            context.setProperty(name, value, scope);
        }
        if (exchange != null) {
            for (Map.Entry property : exchange.getProperties().entrySet()) {
                name = (String)property.getKey();
                if (!this.matches(name) || (value = property.getValue()) == null) continue;
                context.setProperty(name, value, Scope.EXCHANGE);
            }
        }
    }

    public void mapTo(Context context, Message target) throws Exception {
        Exchange exchange = target.getExchange();
        for (Scope scope : IN_OUT) {
            for (Property property : context.getProperties(scope)) {
                Object value;
                String name = property.getName();
                if (!this.matches(name) || (value = property.getValue()) == null) continue;
                target.setHeader(name, value);
            }
        }
        if (exchange != null) {
            for (Property property : context.getProperties(Scope.EXCHANGE)) {
                Object value;
                String name = property.getName();
                if (!this.matches(name) || (value = property.getValue()) == null) continue;
                exchange.setProperty(name, value);
            }
        }
    }
}

