/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.config.model.atom.v1;

import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.switchyard.component.camel.config.model.QueryString;
import org.switchyard.component.camel.config.model.atom.AtomBindingModel;
import org.switchyard.component.camel.config.model.v1.NameValueModel;
import org.switchyard.component.camel.config.model.v1.V1BaseCamelBindingModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;

public class V1AtomBindingModel
extends V1BaseCamelBindingModel
implements AtomBindingModel {
    public static final String ATOM = "atom";
    private static final String FEED_URI = "feedURI";
    private static final String SPLIT_ENTRIES = "splitEntries";
    private static final String FILTER = "filter";
    private static final String LAST_UPDATE = "lastUpdate";
    private static final String THROTTLE_ENTRIES = "throttleEntries";
    private static final String FEED_HEADER = "feedHeader";
    private static final String SORT_ENTRIES = "sortEntries";
    private static final String DELAY = "consumer.delay";
    private static final String INITIAL_DELAY = "consumer.initialDelay";
    private static final String FIXED_DELAY = "consumer.userFixedDelay";
    private static DateFormat _dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public V1AtomBindingModel() {
        super(ATOM);
        this.setModelChildrenOrder(new String[]{FEED_URI, SPLIT_ENTRIES, FILTER, LAST_UPDATE, THROTTLE_ENTRIES, FEED_HEADER, SORT_ENTRIES, DELAY, INITIAL_DELAY, FIXED_DELAY});
    }

    public V1AtomBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    @Override
    public Integer getDelay() {
        return this.getIntegerConfig(DELAY);
    }

    @Override
    public V1AtomBindingModel setDelay(int delay) {
        this.setConfig(DELAY, String.valueOf(delay));
        return this;
    }

    @Override
    public URI getFeedURI() {
        String uriStr = this.getConfig(FEED_URI);
        if (uriStr != null) {
            return URI.create(uriStr);
        }
        return null;
    }

    @Override
    public V1AtomBindingModel setFeedURI(URI uri) {
        this.setConfig(FEED_URI, uri.toString());
        return this;
    }

    @Override
    public Boolean isFixedDelay() {
        return this.getBooleanConfig(FIXED_DELAY);
    }

    @Override
    public V1AtomBindingModel setFixedDelay(boolean delay) {
        this.setConfig(FIXED_DELAY, String.valueOf(delay));
        return this;
    }

    @Override
    public Integer getInitialDelay() {
        return this.getIntegerConfig(INITIAL_DELAY);
    }

    @Override
    public V1AtomBindingModel setInitialDelay(int delay) {
        this.setConfig(INITIAL_DELAY, String.valueOf(delay));
        return this;
    }

    @Override
    public Date getLastUpdate() {
        return this.getDateConfig(LAST_UPDATE, _dateFormat);
    }

    @Override
    public V1AtomBindingModel setLastUpdate(Date date) {
        this.setConfig(LAST_UPDATE, _dateFormat.format(date));
        return this;
    }

    @Override
    public Boolean isFeedHeader() {
        return this.getBooleanConfig(FEED_HEADER);
    }

    @Override
    public V1AtomBindingModel setFeedHeader(boolean feedHeader) {
        this.setConfig(FEED_HEADER, String.valueOf(feedHeader));
        return this;
    }

    @Override
    public Boolean isFiltered() {
        return this.getBooleanConfig(FILTER);
    }

    @Override
    public V1AtomBindingModel setFiltered(boolean filtered) {
        this.setConfig(FILTER, String.valueOf(filtered));
        return this;
    }

    @Override
    public Boolean isSorted() {
        return this.getBooleanConfig(SORT_ENTRIES);
    }

    @Override
    public V1AtomBindingModel setSorted(boolean sorted) {
        this.setConfig(SORT_ENTRIES, String.valueOf(sorted));
        return this;
    }

    @Override
    public Boolean isSplit() {
        return this.getBooleanConfig(SPLIT_ENTRIES);
    }

    @Override
    public V1AtomBindingModel setSplit(boolean split) {
        this.setConfig(SPLIT_ENTRIES, String.valueOf(split));
        return this;
    }

    @Override
    public Boolean isThrottled() {
        return this.getBooleanConfig(THROTTLE_ENTRIES);
    }

    @Override
    public V1AtomBindingModel setThrottled(boolean throttled) {
        this.setConfig(THROTTLE_ENTRIES, String.valueOf(throttled));
        return this;
    }

    @Override
    public URI getComponentURI() {
        String uriStr = "atom://" + this.getConfig(FEED_URI);
        QueryString queryStr = new QueryString().add(DELAY, this.getConfig(DELAY)).add(FEED_HEADER, this.getConfig(FEED_HEADER)).add(FILTER, this.getConfig(FILTER)).add(FIXED_DELAY, this.getConfig(FIXED_DELAY)).add(INITIAL_DELAY, this.getConfig(INITIAL_DELAY)).add(LAST_UPDATE, this.getConfig(LAST_UPDATE)).add(SORT_ENTRIES, this.getConfig(SORT_ENTRIES)).add(SPLIT_ENTRIES, this.getConfig(SPLIT_ENTRIES)).add(THROTTLE_ENTRIES, this.getConfig(THROTTLE_ENTRIES));
        return URI.create(uriStr.toString() + queryStr);
    }

    private Date getDateConfig(String configName, DateFormat format) {
        String value = this.getConfig(configName);
        if (value == null) {
            return null;
        }
        try {
            return format.parse(value);
        }
        catch (ParseException parseEx) {
            throw new IllegalArgumentException("Failed to parse " + configName + " as a date.", parseEx);
        }
    }

    private Integer getIntegerConfig(String configName) {
        String value = this.getConfig(configName);
        return value != null ? Integer.valueOf(Integer.parseInt(value)) : null;
    }

    private Boolean getBooleanConfig(String configName) {
        String value = this.getConfig(configName);
        return value != null ? Boolean.valueOf(value) : null;
    }

    private String getConfig(String configName) {
        Configuration config = this.getModelConfiguration().getFirstChild(configName);
        if (config != null) {
            return config.getValue();
        }
        return null;
    }

    private void setConfig(String name, String value) {
        Configuration config = this.getModelConfiguration().getFirstChild(name);
        if (config != null) {
            config.setValue(value);
        } else {
            NameValueModel model = new NameValueModel(name);
            model.setValue(value);
            this.setChildModel((Model)model);
        }
    }
}

