/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.config.model.seda.v1;

import java.net.URI;
import org.switchyard.component.camel.config.model.QueryString;
import org.switchyard.component.camel.config.model.seda.CamelSedaBindingModel;
import org.switchyard.component.camel.config.model.v1.NameValueModel;
import org.switchyard.component.camel.config.model.v1.V1BaseCamelBindingModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;

public class V1CamelSedaBindingModel
extends V1BaseCamelBindingModel
implements CamelSedaBindingModel {
    public static final String SEDA = "seda";
    private static final String NAME = "name";
    private static final String SIZE = "size";
    private static final String CONCURRENT_CONSUMERS = "concurrentConsumers";
    private static final String WAIT_FOR_TASK_TO_COMPLETE = "waitForTaskToComplete";
    private static final String TIMEOUT = "timeout";
    private static final String MULTIPLE_CONSUMERS = "multipleConsumers";
    private static final String LIMIT_CONCURRENT_CONSUMERS = "limitConcurrentConsumers";

    public V1CamelSedaBindingModel() {
        super(SEDA);
        this.setModelChildrenOrder(new String[]{NAME, SIZE, CONCURRENT_CONSUMERS, WAIT_FOR_TASK_TO_COMPLETE, TIMEOUT, MULTIPLE_CONSUMERS, LIMIT_CONCURRENT_CONSUMERS});
    }

    public V1CamelSedaBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    @Override
    public URI getComponentURI() {
        String uriStr = "seda://" + this.getConfig(NAME);
        QueryString queryStr = new QueryString().add(SIZE, this.getConfig(SIZE)).add(WAIT_FOR_TASK_TO_COMPLETE, this.getConfig(WAIT_FOR_TASK_TO_COMPLETE)).add(CONCURRENT_CONSUMERS, this.getConfig(CONCURRENT_CONSUMERS)).add(TIMEOUT, this.getConfig(TIMEOUT)).add(MULTIPLE_CONSUMERS, this.getConfig(MULTIPLE_CONSUMERS)).add(LIMIT_CONCURRENT_CONSUMERS, this.getConfig(LIMIT_CONCURRENT_CONSUMERS));
        return URI.create(uriStr.toString() + queryStr);
    }

    @Override
    public String getName() {
        return this.getConfig(NAME);
    }

    @Override
    public CamelSedaBindingModel setName(String name) {
        this.setConfig(NAME, name);
        return this;
    }

    @Override
    public Integer getSize() {
        return this.getIntegerConfig(SIZE);
    }

    @Override
    public CamelSedaBindingModel setSize(Integer size) {
        this.setConfig(SIZE, String.valueOf(size));
        return this;
    }

    @Override
    public Integer getConcurrentConsumers() {
        return this.getIntegerConfig(CONCURRENT_CONSUMERS);
    }

    @Override
    public CamelSedaBindingModel setConcurrentConsumers(Integer concurrentConsumers) {
        this.setConfig(CONCURRENT_CONSUMERS, String.valueOf(concurrentConsumers));
        return this;
    }

    @Override
    public String getWaitForTaskToComplete() {
        return this.getConfig(WAIT_FOR_TASK_TO_COMPLETE);
    }

    @Override
    public CamelSedaBindingModel setWaitForTaskToComplete(String waitForTaskToComplete) {
        this.setConfig(WAIT_FOR_TASK_TO_COMPLETE, waitForTaskToComplete);
        return this;
    }

    @Override
    public Long getTimeout() {
        return this.getLongConfig(TIMEOUT);
    }

    @Override
    public CamelSedaBindingModel setTimeout(Long timeout) {
        this.setConfig(TIMEOUT, String.valueOf(timeout));
        return this;
    }

    @Override
    public Boolean isMultipleConsumers() {
        return this.getBooleanConfig(MULTIPLE_CONSUMERS);
    }

    @Override
    public CamelSedaBindingModel setMultipleConsumers(Boolean multipleConsumers) {
        this.setConfig(MULTIPLE_CONSUMERS, String.valueOf(multipleConsumers));
        return this;
    }

    @Override
    public Boolean isLimitConcurrentConsumers() {
        return this.getBooleanConfig(LIMIT_CONCURRENT_CONSUMERS);
    }

    @Override
    public CamelSedaBindingModel setLimitConcurrentConsumers(Boolean limitConcurrentConsumers) {
        this.setConfig(LIMIT_CONCURRENT_CONSUMERS, String.valueOf(limitConcurrentConsumers));
        return this;
    }

    private Integer getIntegerConfig(String configName) {
        String value = this.getConfig(configName);
        return value != null ? Integer.valueOf(Integer.parseInt(value)) : null;
    }

    private Boolean getBooleanConfig(String configName) {
        String value = this.getConfig(configName);
        return value != null ? Boolean.valueOf(value) : null;
    }

    private Long getLongConfig(String configName) {
        String value = this.getConfig(configName);
        return value != null ? Long.valueOf(Long.parseLong(value)) : null;
    }

    private String getConfig(String configName) {
        Configuration config = this.getModelConfiguration().getFirstChild(configName);
        if (config != null) {
            return config.getValue();
        }
        return null;
    }

    private void setConfig(String name, String value) {
        Configuration config = this.getModelConfiguration().getFirstChild(name);
        if (config != null) {
            config.setValue(value);
        } else {
            NameValueModel model = new NameValueModel(name);
            model.setValue(value);
            this.setChildModel((Model)model);
        }
    }
}

