/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel;

import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultProducer;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.Message;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.component.camel.CamelResponseHandler;
import org.switchyard.component.camel.deploy.ComponentNameComposer;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.policy.Policy;
import org.switchyard.policy.PolicyUtil;
import org.switchyard.policy.TransactionPolicy;

public class SwitchYardProducer
extends DefaultProducer {
    private String _namespace;
    private String _operationName;
    private final MessageComposer<org.apache.camel.Message> _messageComposer;

    public SwitchYardProducer(Endpoint endpoint, String namespace, String operationName, MessageComposer<org.apache.camel.Message> messageComposer) {
        super(endpoint);
        this._namespace = namespace;
        this._operationName = operationName;
        this._messageComposer = messageComposer;
    }

    public void process(org.apache.camel.Exchange camelExchange) throws Exception {
        String targetUri = (String)camelExchange.getProperty("CamelToEndpoint");
        ServiceDomain domain = (ServiceDomain)camelExchange.getContext().getRegistry().lookup("org.switchyard.camel.serviceDomain");
        ServiceReference serviceRef = this.lookupServiceReference(targetUri, domain);
        Exchange switchyardExchange = this.createSwitchyardExchange(camelExchange, serviceRef);
        if (camelExchange.isTransacted()) {
            PolicyUtil.provide((Exchange)switchyardExchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
        }
        Message switchyardMessage = this._messageComposer.compose((Object)camelExchange.getIn(), switchyardExchange, true);
        switchyardExchange.send(switchyardMessage);
    }

    private ServiceReference lookupServiceReference(String targetUri, ServiceDomain domain) {
        QName serviceName = ComponentNameComposer.composeSwitchYardServiceName(this._namespace, targetUri);
        ServiceReference serviceRef = domain.getServiceReference(serviceName);
        if (serviceRef == null) {
            throw new NullPointerException("No ServiceReference was found for uri [" + targetUri + "]");
        }
        return serviceRef;
    }

    private Exchange createSwitchyardExchange(org.apache.camel.Exchange camelExchange, ServiceReference serviceRef) {
        return serviceRef.createExchange(this.lookupOperationNameFor(camelExchange, serviceRef), (ExchangeHandler)new CamelResponseHandler(camelExchange, serviceRef, this._messageComposer));
    }

    private String lookupOperationNameFor(org.apache.camel.Exchange camelExchange, ServiceReference serviceRef) {
        String operationName = (String)camelExchange.getIn().getHeader("operationName");
        if (this._operationName != null) {
            operationName = this._operationName;
        }
        if (operationName == null) {
            Set operations = serviceRef.getInterface().getOperations();
            if (operations.size() != 1) {
                StringBuilder msg = new StringBuilder();
                msg.append("No operationSelector was configured for the Camel Component and the Service Interface ");
                msg.append("contains more than one operation: ").append(operations);
                msg.append("Please add an operationSelector element with the target 'operationName' as an attribute.");
                throw new SwitchYardException(msg.toString());
            }
            ServiceOperation serviceOperation = (ServiceOperation)operations.iterator().next();
            operationName = serviceOperation.getName();
        }
        return operationName;
    }
}

