/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.composer;

import java.io.InputStream;
import javax.xml.namespace.QName;
import org.switchyard.Exchange;
import org.switchyard.Message;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.component.common.composer.BaseMessageComposer;
import org.switchyard.metadata.ServiceOperation;

public class CamelMessageComposer
extends BaseMessageComposer<org.apache.camel.Message> {
    public Message compose(org.apache.camel.Message source, Exchange exchange, boolean create) throws Exception {
        this.getContextMapper().mapFrom((Object)source, exchange.getContext());
        Message message = create ? exchange.createMessage() : exchange.getMessage();
        QName msgType = this.getMessageType(exchange);
        Object content = msgType == null ? source.getBody() : (QNameUtil.isJavaMessageType((QName)msgType) ? source.getBody(QNameUtil.toJavaMessageType((QName)msgType)) : source.getBody(InputStream.class));
        message.setContent(content);
        return message;
    }

    public org.apache.camel.Message decompose(Exchange exchange, org.apache.camel.Message target) throws Exception {
        this.getContextMapper().mapTo(exchange.getContext(), (Object)target);
        ServiceOperation operation = exchange.getContract().getServiceOperation();
        target.setHeader("org.switchyard.operationName", (Object)operation.getName());
        target.setHeader("org.switchyard.faultType", (Object)operation.getFaultType());
        target.setHeader("org.switchyard.serviceName", (Object)exchange.getServiceName());
        target.setBody(exchange.getMessage().getContent());
        return target;
    }

    private QName getMessageType(Exchange exchange) {
        QName msgType = exchange.getPhase() == null ? exchange.getContract().getInvokerInvocationMetaData().getInputType() : exchange.getContract().getInvokerInvocationMetaData().getOutputType();
        return msgType;
    }
}

