/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.config.model.quartz.v1;

import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.switchyard.component.camel.config.model.QueryString;
import org.switchyard.component.camel.config.model.quartz.CamelQuartzBindingModel;
import org.switchyard.component.camel.config.model.v1.V1BaseCamelBindingModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;

public class V1CamelQuartzBindingModel
extends V1BaseCamelBindingModel
implements CamelQuartzBindingModel {
    public static final String QUARTZ = "quartz";
    private static final String NAME = "name";
    private static final String CRON = "cron";
    private static final String STATEFUL = "stateful";
    private static final String START_TIME = "trigger.startTime";
    private static final String END_TIME = "trigger.endTime";
    private static DateFormat _dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public V1CamelQuartzBindingModel() {
        super(QUARTZ);
        this.setModelChildrenOrder(new String[]{NAME, CRON, STATEFUL, START_TIME, END_TIME});
    }

    public V1CamelQuartzBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    @Override
    public String getName() {
        return this.getConfig(NAME);
    }

    @Override
    public V1CamelQuartzBindingModel setName(String name) {
        return (V1CamelQuartzBindingModel)this.setConfig(NAME, name);
    }

    @Override
    public String getCron() {
        return this.getConfig(CRON);
    }

    @Override
    public V1CamelQuartzBindingModel setCron(String cron) {
        return (V1CamelQuartzBindingModel)this.setConfig(CRON, cron);
    }

    @Override
    public Boolean isStateful() {
        return this.getBooleanConfig(STATEFUL);
    }

    @Override
    public V1CamelQuartzBindingModel setStateful(Boolean stateful) {
        return (V1CamelQuartzBindingModel)this.setConfig(STATEFUL, stateful);
    }

    @Override
    public Date getStartTime() {
        return this.getDateConfig(START_TIME, _dateFormat);
    }

    @Override
    public V1CamelQuartzBindingModel setStartTime(Date startTime) {
        return (V1CamelQuartzBindingModel)this.setConfig(START_TIME, _dateFormat.format(startTime));
    }

    @Override
    public Date getEndTime() {
        return this.getDateConfig(END_TIME, _dateFormat);
    }

    @Override
    public V1CamelQuartzBindingModel setEndTime(Date endTime) {
        return (V1CamelQuartzBindingModel)this.setConfig(END_TIME, _dateFormat.format(endTime));
    }

    @Override
    public URI getComponentURI() {
        Configuration modelConfiguration = this.getModelConfiguration();
        List children = modelConfiguration.getChildren();
        String baseUri = "quartz://" + this.getName();
        QueryString queryStr = new QueryString();
        this.traverseConfiguration(children, queryStr, NAME);
        return URI.create(UnsafeUriCharactersEncoder.encode((String)(baseUri + queryStr.toString())));
    }
}

