/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.deploy;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.camel.SwitchYardRouteDefinition;

public final class ComponentNameComposer {
    public static final String SWITCHYARD_COMPONENT_NAME = "switchyard";

    private ComponentNameComposer() {
    }

    public static String composeComponentUri(QName serviceName) {
        StringBuilder sb = new StringBuilder();
        sb.append(SWITCHYARD_COMPONENT_NAME).append("://").append(serviceName.getLocalPart());
        return SwitchYardRouteDefinition.addNamespaceParameter(sb.toString(), serviceName.getNamespaceURI());
    }

    public static QName composeSwitchYardServiceName(String namespace, String uri) {
        URI create = URI.create(uri);
        String path = create.getAuthority();
        return XMLHelper.createQName((String)namespace, (String)path);
    }

    public static String getNamespaceFromURI(URI uri) {
        return ComponentNameComposer.getQueryParamMap(uri).get("namespace");
    }

    public static Map<String, String> getQueryParamMap(URI uri) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : uri.getQuery().split("&")) {
            String[] nameValue = param.split("=");
            if (nameValue.length != 2) continue;
            map.put(nameValue[0], nameValue[1]);
        }
        return map;
    }
}

