/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.config.model.v1;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.switchyard.component.camel.config.model.CamelBindingModel;
import org.switchyard.component.camel.config.model.OperationSelector;
import org.switchyard.component.camel.config.model.QueryString;
import org.switchyard.component.camel.config.model.v1.NameValueModel;
import org.switchyard.component.camel.config.model.v1.V1OperationSelector;
import org.switchyard.config.Configuration;
import org.switchyard.config.Configurations;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.v1.V1BindingModel;

public abstract class V1BaseCamelBindingModel
extends V1BindingModel
implements CamelBindingModel {
    public static final String CAMEL = "camel";
    private OperationSelector _operationSelector;
    private Configuration _environment = Configurations.emptyConfig();

    public V1BaseCamelBindingModel() {
        this(CAMEL);
        this.setModelChildrenOrder(new String[0]);
    }

    public V1BaseCamelBindingModel(String type) {
        super(type, "urn:switchyard-component-camel:config:1.0");
    }

    public V1BaseCamelBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
        this.setModelChildrenOrder(new String[0]);
    }

    @Override
    public OperationSelector getOperationSelector() {
        if (this._operationSelector == null) {
            this._operationSelector = (V1OperationSelector)this.getFirstChildModelStartsWith("operationSelector");
        }
        return this._operationSelector;
    }

    @Override
    public V1BaseCamelBindingModel setOperationSelector(OperationSelector operationSelector) {
        if (this._operationSelector == null) {
            this.setChildModel((Model)operationSelector);
        }
        return this;
    }

    public Configuration getEnvironment() {
        return this._environment;
    }

    @Override
    public void setEnvironment(Configuration config) {
        this._environment = config;
    }

    protected final void traverseConfiguration(List<Configuration> parent, QueryString queryString, String ... excludes) {
        if (parent.size() != 0) {
            ArrayList<String> excludeParameters = new ArrayList<String>(Arrays.asList(excludes));
            excludeParameters.add("operationSelector");
            for (Configuration child : parent) {
                if (child != null && child.getName() != null && excludeParameters.contains(child.getName())) continue;
                if (child != null && child.getChildren().size() == 0) {
                    queryString.add(child.getName(), child.getValue());
                    continue;
                }
                this.traverseConfiguration(child.getChildren(), queryString, excludes);
            }
        }
    }

    protected final Integer getIntegerConfig(String configName) {
        String value = this.getConfig(configName);
        return value != null ? Integer.valueOf(Integer.parseInt(value)) : null;
    }

    protected final Boolean getBooleanConfig(String configName) {
        String value = this.getConfig(configName);
        return value != null ? Boolean.valueOf(value) : null;
    }

    protected final Long getLongConfig(String configName) {
        String value = this.getConfig(configName);
        return value != null ? Long.valueOf(Long.parseLong(value)) : null;
    }

    protected final Date getDateConfig(String configName, DateFormat format) {
        String value = this.getConfig(configName);
        if (value == null) {
            return null;
        }
        try {
            return format.parse(value);
        }
        catch (ParseException parseEx) {
            throw new IllegalArgumentException("Failed to parse " + configName + " as a date.", parseEx);
        }
    }

    protected final String getConfig(String configName) {
        Configuration config = this.getModelConfiguration().getFirstChild(configName);
        if (config != null) {
            return config.getValue();
        }
        return null;
    }

    protected final <T extends Enum<T>> T getEnumerationConfig(String configName, Class<T> type) {
        String constantName = this.getConfig(configName);
        if (constantName != null) {
            return Enum.valueOf(type, constantName);
        }
        return null;
    }

    protected <X extends V1BaseCamelBindingModel> X setConfig(String name, Object value) {
        String modelValue = String.valueOf(value);
        Configuration config = this.getModelConfiguration().getFirstChild(name);
        if (config != null) {
            config.setValue(modelValue);
        } else {
            NameValueModel model = new NameValueModel(name);
            model.setValue(modelValue);
            this.setChildModel((Model)model);
        }
        return (X)this;
    }
}

