/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.config.model.timer.v1;

import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.switchyard.component.camel.config.model.QueryString;
import org.switchyard.component.camel.config.model.timer.CamelTimerBindingModel;
import org.switchyard.component.camel.config.model.v1.V1BaseCamelBindingModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;

public class V1CamelTimerBindingModel
extends V1BaseCamelBindingModel
implements CamelTimerBindingModel {
    public static final String TIMER = "timer";
    private static final String NAME = "name";
    private static final String TIME = "time";
    private static final String PATTERN = "pattern";
    private static final String PERIOD = "period";
    private static final String DELAY = "delay";
    private static final String FIXED_RATE = "fixedRate";
    private static final String DAEMON = "daemon";
    private static DateFormat _dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public V1CamelTimerBindingModel() {
        super(TIMER);
        this.setModelChildrenOrder(new String[]{NAME, TIME, PATTERN, PERIOD, DELAY, FIXED_RATE, DAEMON});
    }

    public V1CamelTimerBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    @Override
    public String getName() {
        return this.getConfig(NAME);
    }

    @Override
    public CamelTimerBindingModel setName(String name) {
        this.setConfig(NAME, name);
        return this;
    }

    @Override
    public Date getTime() {
        return this.getDateConfig(TIME, _dateFormat);
    }

    @Override
    public CamelTimerBindingModel setTime(Date time) {
        this.setConfig(TIME, _dateFormat.format(time));
        return this;
    }

    @Override
    public String getPattern() {
        return this.getConfig(PATTERN);
    }

    @Override
    public CamelTimerBindingModel setPattern(String pattern) {
        this.setConfig(PATTERN, pattern);
        return this;
    }

    @Override
    public Long getPeriod() {
        return this.getLongConfig(PERIOD);
    }

    @Override
    public CamelTimerBindingModel setPeriod(Long period) {
        this.setConfig(PERIOD, String.valueOf(period));
        return this;
    }

    @Override
    public Long getDelay() {
        return this.getLongConfig(DELAY);
    }

    @Override
    public CamelTimerBindingModel setDelay(Long delay) {
        this.setConfig(DELAY, String.valueOf(delay));
        return this;
    }

    @Override
    public Boolean isFixedRate() {
        return this.getBooleanConfig(FIXED_RATE);
    }

    @Override
    public CamelTimerBindingModel setFixedRate(Boolean fixedRate) {
        this.setConfig(FIXED_RATE, String.valueOf(fixedRate));
        return this;
    }

    @Override
    public Boolean isDaemon() {
        return this.getBooleanConfig(DAEMON);
    }

    @Override
    public CamelTimerBindingModel setDaemon(Boolean daemon) {
        this.setConfig(DAEMON, String.valueOf(daemon));
        return this;
    }

    @Override
    public URI getComponentURI() {
        String uriStr = "timer://" + this.getConfig(NAME);
        QueryString queryStr = new QueryString().add(TIME, this.getConfig(TIME)).add(PATTERN, this.getConfig(PATTERN)).add(PERIOD, this.getConfig(PERIOD)).add(DELAY, this.getConfig(DELAY)).add(FIXED_RATE, this.getConfig(FIXED_RATE)).add(DAEMON, this.getConfig(DAEMON));
        return URI.create(uriStr.toString() + queryStr);
    }
}

